/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.queries;

import java.io.File;
import org.mevenide.netbeans.project.MavenProject;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenSharabilityQueryImpl
implements SharabilityQueryImplementation {
    private MavenProject project;

    public MavenSharabilityQueryImpl(MavenProject proj) {
        this.project = proj;
    }

    public Boolean isSharable(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        return this.checkShare(file);
    }

    public Boolean willBeSharable(FileObject fileObject, String str, boolean directory) {
        File parent = FileUtil.toFile((FileObject)fileObject);
        File child = new File(parent, str);
        return this.checkShare(child);
    }

    private boolean checkShare(File file) {
        File basedir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (!file.getAbsolutePath().startsWith(basedir.getAbsolutePath())) {
            return false;
        }
        File target = new File(this.project.getPropertyResolver().getResolvedValue("maven.build.dir"));
        if (target.equals(file) || file.getAbsolutePath().startsWith(target.getAbsolutePath())) {
            return false;
        }
        File buildProps = new File(basedir, "build.properties");
        if (file.equals(buildProps)) {
            return false;
        }
        if (file.equals(new File(basedir, "velocity.log"))) {
            return false;
        }
        return !file.equals(new File(basedir, "jcoverage.ser"));
    }

    public int getSharability(File file) {
        if (this.checkShare(file)) {
            return 1;
        }
        return 2;
    }
}

