/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import java.util.List;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;
import net.aihelp.core.db.LocaleIgnoredOpenHelper;
import net.aihelp.utils.ListUtil;

public class BaseSQLiteHelper
extends LocaleIgnoredOpenHelper {
    private IDatabaseContract contract;
    private IDbMigrationListener listener;

    public BaseSQLiteHelper(Context context, IDatabaseContract contract) {
        super(context, contract.getDatabaseName(), null, contract.getDatabaseVersion());
        this.contract = contract;
    }

    public void setListener(IDbMigrationListener listener) {
        this.listener = listener;
    }

    public void onCreate(SQLiteDatabase db) {
        try {
            db.beginTransaction();
            this.createAllTables(db);
            db.setTransactionSuccessful();
        }
        finally {
            try {
                if (db.inTransaction()) {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        List<IMigrateContract> migrators = this.contract.getMigratorsForUpgrade(oldVersion);
        if (!ListUtil.isListEmpty(migrators)) {
            boolean isMigrated = this.migrate(db, migrators, oldVersion);
            if (this.listener != null) {
                if (isMigrated) {
                    this.listener.onDbMigrationSuccess(MigrationType.UPGRADE, this.contract.getDatabaseName());
                } else {
                    this.listener.onDbMigrationFailed(MigrationType.UPGRADE, this.contract.getDatabaseName());
                }
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        boolean allTablesRecreated = this.dropAndCreateAllTables(db, true);
        if (this.listener != null) {
            if (allTablesRecreated) {
                this.listener.onDbMigrationSuccess(MigrationType.DOWNGRADE, this.contract.getDatabaseName());
            } else {
                this.listener.onDbMigrationFailed(MigrationType.DOWNGRADE, this.contract.getDatabaseName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropAndCreateAllTables(SQLiteDatabase db, boolean throwException) {
        if (db.isOpen()) {
            boolean var4;
            try {
                db.beginTransaction();
                this.dropAllTables(db);
                this.createAllTables(db);
                db.setTransactionSuccessful();
                boolean bl = true;
                return bl;
            }
            catch (Exception var14) {
                if (throwException) {
                    throw var14;
                }
                var4 = false;
            }
            finally {
                try {
                    if (db.inTransaction()) {
                        db.endTransaction();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return var4;
        }
        return true;
    }

    public boolean dropAndCreateAllTables(SQLiteDatabase db) {
        return this.dropAndCreateAllTables(db, false);
    }

    private void dropAllTables(SQLiteDatabase db) {
        for (String tableName : this.contract.getTableNames()) {
            db.execSQL("DROP TABLE IF EXISTS " + tableName);
        }
    }

    private void createAllTables(SQLiteDatabase db) {
        for (String query : this.contract.getCreateTableQueries()) {
            db.execSQL(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migrate(SQLiteDatabase db, List<IMigrateContract> migrators, int oldVersion) {
        boolean isMigrationSuccess = true;
        try {
            db.beginTransaction();
            for (IMigrateContract migrator : migrators) {
                migrator.migrate(db);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception var15) {
            isMigrationSuccess = false;
        }
        finally {
            try {
                if (db.inTransaction()) {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isMigrationSuccess) {
            this.dropAndCreateAllTables(db, true);
        }
        return isMigrationSuccess;
    }

    public synchronized void clearDatabase() {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            this.dropAndCreateAllTables(database);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum MigrationType {
        UPGRADE,
        DOWNGRADE;

    }

    public static interface IDbMigrationListener {
        public void onDbMigrationSuccess(MigrationType var1, String var2);

        public void onDbMigrationFailed(MigrationType var1, String var2);
    }
}

