/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.db;

import android.database.sqlite.SQLiteDatabase;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;

public class DropAndCreateDatabaseHelper
implements IMigrateContract {
    private IDatabaseContract contract;

    public DropAndCreateDatabaseHelper(IDatabaseContract contract) {
        this.contract = contract;
    }

    @Override
    public void migrate(SQLiteDatabase db) {
        this.dropAllTables(db);
        this.createAllTables(db);
    }

    private void dropAllTables(SQLiteDatabase db) {
        for (String tableName : this.contract.getTableNames()) {
            db.execSQL("DROP TABLE IF EXISTS " + tableName);
        }
    }

    private void createAllTables(SQLiteDatabase db) {
        for (String query : this.contract.getCreateTableQueries()) {
            db.execSQL(query);
        }
    }
}

