/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.mvp;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.aihelp.core.mvp.IPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.BaseCallback;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.ToastUtil;
import okhttp3.Call;
import org.json.JSONObject;

public abstract class AbsPresenter<V extends IView, R extends IRepository>
implements IPresenter<V> {
    protected V mView;
    protected R mRepo;
    protected final Context mContext;
    protected SpUtil mSp;

    public AbsPresenter(Context context) {
        this.mContext = context;
        this.mRepo = this.initRepository();
        this.mSp = SpUtil.getInstance();
        this.initOtherRepository();
    }

    protected void initOtherRepository() {
    }

    @Override
    public void attachView(V view) {
        this.mView = view;
    }

    @Override
    public void detachView() {
        this.mView = null;
    }

    public boolean isNetworkAvailable() {
        if (this.mContext == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    protected R initRepository() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            Class repoClass = (Class)types[1];
            if (repoClass == IRepository.class) {
                return null;
            }
            try {
                Constructor constructor = repoClass.getDeclaredConstructor(Context.class);
                return (R)((IRepository)constructor.newInstance(this.mContext));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected <T> void get(String url, JSONObject params, BaseCallback<T> callBack) {
        if (!this.isNetworkAvailable()) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
            return;
        }
        AIHelpRequest.getInstance().requestGetByAsync(url, params, callBack);
    }

    protected <T> Call post(String url, JSONObject params, BaseCallback<T> callBack) {
        if (!this.isNetworkAvailable()) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
            return null;
        }
        return AIHelpRequest.getInstance().requestPostByJson(url, params, callBack);
    }

    protected void mqtt(String topicName, JSONObject params) {
        if (!this.isNetworkAvailable()) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
            return;
        }
        AIHelpMqtt.getInstance().postToServer(topicName, params);
    }
}

