/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.check;

import android.os.AsyncTask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import net.aihelp.core.net.check.Task;

public final class Ping
implements Task {
    private final String address;
    private final int count;
    private final int size;
    private final Callback complete;
    private volatile boolean stopped;
    private int interval;

    private Ping(String address, int count, Callback complete) {
        this(address, count, 56, 200, complete);
    }

    private Ping(String address, int count, int size, int interval, Callback complete) {
        this.address = address;
        this.count = count;
        this.size = size;
        this.interval = interval;
        this.complete = complete;
        this.stopped = false;
    }

    public static Task start(String address, Callback complete) {
        return Ping.start(address, 5, complete);
    }

    public static Task start(String address, int count, Callback complete) {
        final Ping p = new Ping(address, count, complete);
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                p.run();
            }
        });
        return p;
    }

    private static String getIp(String host) throws UnknownHostException {
        InetAddress i = InetAddress.getByName(host);
        return i.getHostAddress();
    }

    private void run() {
        Result r = this.pingCmd();
        this.complete.complete(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result pingCmd() {
        String ip;
        try {
            ip = Ping.getIp(this.address);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return new Result("", "", 0, 0);
        }
        boolean isIpv6 = false;
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (address instanceof Inet6Address) {
                isIpv6 = true;
            } else if (!(address instanceof Inet4Address)) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String strFmt = "ping -n -i %f -s %d -c %d %s";
        if (isIpv6) {
            strFmt = "ping6 -n -i %f -s %d -c %d %s";
        }
        String cmd = String.format(Locale.getDefault(), strFmt, (double)this.interval / 1000.0, this.size, this.count, ip);
        Process process = null;
        StringBuilder str = new StringBuilder();
        BufferedReader reader = null;
        BufferedReader errorReader = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(cmd);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if ("".equals(str.toString())) {
                str.append("Ping host address is ").append(this.address).append(".").append("\n");
            }
            while ((line = reader.readLine()) != null) {
                str.append(line).append("\n");
            }
            while ((line = errorReader.readLine()) != null) {
                str.append(line);
            }
            reader.close();
            errorReader.close();
            process.waitFor();
            return new Result(str.toString(), ip, this.size, this.interval);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Result(str.toString(), ip, this.size, this.interval);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    public static class Result {
        public final String result;
        public final String ip;
        public final int size;
        public final int interval;
        private final String lastLinePrefix = "rtt min/avg/max/mdev = ";
        private final String packetWords = " packets transmitted";
        private final String receivedWords = " received";
        public int sent;
        public int dropped;
        public float max;
        public float min;
        public float avg;
        public float stddev;
        public int count;

        Result(String result, String ip, int size, int interval) {
            this.result = result;
            this.ip = ip;
            this.size = size;
            this.interval = interval;
            this.parseResult();
        }

        static String trimNoneDigital(String s) {
            if (s == null || s.length() == 0) {
                return "";
            }
            char[] v = s.toCharArray();
            char[] v2 = new char[v.length];
            int j = 0;
            for (char aV : v) {
                if ((aV < '0' || aV > '9') && aV != '.') continue;
                v2[j++] = aV;
            }
            return new String(v2, 0, j);
        }

        private void parseRttLine(String s) {
            String s2 = s.substring("rtt min/avg/max/mdev = ".length(), s.length() - 3);
            String[] l = s2.split("/");
            if (l.length != 4) {
                return;
            }
            this.min = Float.parseFloat(Result.trimNoneDigital(l[0]));
            this.avg = Float.parseFloat(Result.trimNoneDigital(l[1]));
            this.max = Float.parseFloat(Result.trimNoneDigital(l[2]));
            this.stddev = Float.parseFloat(Result.trimNoneDigital(l[3]));
        }

        private void parsePacketLine(String s) {
            String[] l = s.split(",");
            if (l.length != 4) {
                return;
            }
            if (l[0].length() > " packets transmitted".length()) {
                String s2 = l[0].substring(0, l[0].length() - " packets transmitted".length());
                this.count = Integer.parseInt(s2);
            }
            if (l[1].length() > " received".length()) {
                String s3 = l[1].substring(0, l[1].length() - " received".length());
                this.sent = Integer.parseInt(s3.trim());
            }
            this.dropped = this.count - this.sent;
        }

        private void parseResult() {
            String[] rs = this.result.split("\n");
            try {
                for (String s : rs) {
                    if (s.contains(" packets transmitted")) {
                        this.parsePacketLine(s);
                        continue;
                    }
                    if (!s.contains("rtt min/avg/max/mdev = ")) continue;
                    this.parseRttLine(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface Callback {
        public void complete(Result var1);
    }
}

