/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.interceptor;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import java.io.IOException;
import net.aihelp.common.API;
import net.aihelp.utils.TLog;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONObject;

public final class LogInterceptor
implements Interceptor {
    @SuppressLint(value={"DefaultLocale"})
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        try {
            String urlInfo = this.getLineTag(request.url());
            if (TextUtils.isEmpty((CharSequence)urlInfo) || this.isFileAddress(urlInfo)) {
                return response;
            }
            TLog.l(urlInfo, true);
            long startTime = System.currentTimeMillis();
            if ("POST".equals(request.method()) && request.body() != null) {
                MediaType mediaType;
                if (request.body() instanceof FormBody) {
                    FormBody body = (FormBody)request.body();
                    JSONObject jsonObject = new JSONObject();
                    for (int i = 0; i < body.size(); ++i) {
                        jsonObject.put(body.encodedName(i), (Object)body.encodedValue(i));
                    }
                    TLog.json(String.format("[%s] [%s]", "Params", request.url()), jsonObject.toString());
                }
                if ((mediaType = request.body().contentType()) != null && "json".equals(mediaType.subtype())) {
                    String postJson = this.bodyToString(request.body());
                    TLog.json(String.format("[%s] [%s]", "Params", request.url()), postJson);
                }
            }
            long endTime = System.currentTimeMillis();
            if (!TextUtils.isEmpty((CharSequence)urlInfo) && !this.isFileAddress(urlInfo)) {
                ResponseBody responseBody = response.peekBody(0x100000L);
                TLog.json(String.format("[%s] [%s]", request.method(), request.url()), responseBody.string());
            }
            TLog.e("Request Time: " + (double)(endTime - startTime) * 1.0 / 1000.0 + "s\t\t");
            TLog.l(urlInfo, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private String bodyToString(RequestBody request) {
        try {
            RequestBody copy = request;
            Buffer buffer = new Buffer();
            if (copy == null) {
                return "";
            }
            copy.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "";
        }
    }

    private String getLineTag(HttpUrl url) {
        String host = url.scheme() + "://" + url.host();
        String tag = url.toString().replace(host, "");
        if (tag.contains("?")) {
            tag = " " + tag.substring(0, tag.indexOf("?"));
        } else if (this.isFileAddress(tag)) {
            tag = "";
        }
        return tag;
    }

    private boolean isFileAddress(String url) {
        return API.FAQ_URL.contains(url.trim()) || API.OP_URL.contains(url.trim()) || url.endsWith(".json") || url.endsWith(".aiml") || url.endsWith(".ini") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".png") || url.endsWith(".mp4");
    }
}

