/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.monitor;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.core.net.monitor.NetworkMonitor;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.net.monitor.NetworkStateReceiverMethod;
import net.aihelp.utils.TLog;

public class NetworkMonitorManager {
    public static final String TAG = "NetWorkMonitor >>> : ";
    private static NetworkMonitorManager ourInstance;
    private Context mContext;
    private NetworkCallback mNetworkCallback;
    private boolean isFirstReceived;
    private Map<Object, NetworkStateReceiverMethod> netWorkStateChangedMethodMap = new ConcurrentHashMap<Object, NetworkStateReceiverMethod>();
    private static final String ANDROID_NET_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (NetworkMonitorManager.this.isFirstReceived) {
                return;
            }
            if (NetworkMonitorManager.ANDROID_NET_CHANGE_ACTION.equalsIgnoreCase(intent.getAction())) {
                NetworkState netWorkState;
                int netType = NetworkMonitorManager.getAPNType(context);
                switch (netType) {
                    case 0: {
                        netWorkState = NetworkState.NONE;
                        break;
                    }
                    case 1: {
                        netWorkState = NetworkState.WIFI;
                        break;
                    }
                    default: {
                        netWorkState = NetworkState.CELLULAR;
                    }
                }
                NetworkMonitorManager.this.postNetState(netWorkState);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkMonitorManager getInstance() {
        Class<NetworkMonitorManager> clazz = NetworkMonitorManager.class;
        synchronized (NetworkMonitorManager.class) {
            if (ourInstance == null) {
                ourInstance = new NetworkMonitorManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    private NetworkMonitorManager() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNetworkCallback = new NetworkCallback();
        }
    }

    public void init(Context context) {
        if (context == null) {
            TLog.e("NetworkMonitorManager init Context can not be null");
            return;
        }
        this.mContext = context;
    }

    private void initMonitor() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager != null && this.mNetworkCallback != null) {
            if (Build.VERSION.SDK_INT >= 26) {
                connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
            } else if (Build.VERSION.SDK_INT >= 21) {
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                NetworkRequest request = builder.build();
                connectivityManager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)this.mNetworkCallback);
            }
        }
    }

    private void onDestroy() {
        if (Build.VERSION.SDK_INT < 21 && this.mContext != null) {
            this.mContext.unregisterReceiver(this.receiver);
            this.isFirstReceived = false;
        }
    }

    public void register(Object object) {
        try {
            if (this.mContext != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                if (connectivityManager != null && this.mNetworkCallback != null) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        NetworkRequest.Builder builder = new NetworkRequest.Builder();
                        NetworkRequest request = builder.build();
                        connectivityManager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)this.mNetworkCallback);
                    }
                }
                if (object != null) {
                    Class myClass = object.getClass();
                    while (myClass != null) {
                        NetworkStateReceiverMethod NetworkStateReceiverMethod2 = this.findMethod(object, myClass);
                        if (NetworkStateReceiverMethod2 != null) {
                            this.netWorkStateChangedMethodMap.put(object, NetworkStateReceiverMethod2);
                        }
                        myClass = this.moveToSuperclass(myClass);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(Object object) {
        try {
            if (this.mContext != null) {
                ConnectivityManager connectivityManager;
                if (object != null && this.netWorkStateChangedMethodMap != null) {
                    this.netWorkStateChangedMethodMap.remove(object);
                }
                if ((connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity")) != null && this.mNetworkCallback != null && Build.VERSION.SDK_INT >= 21) {
                    connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.mNetworkCallback);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class moveToSuperclass(Class clazz) {
        String clazzName;
        if (clazz == null) {
            return null;
        }
        if ((clazz = clazz.getSuperclass()) != null && ((clazzName = clazz.getName()).startsWith("java.") || clazzName.startsWith("javax.") || clazzName.startsWith("android.") || clazzName.startsWith("androidx."))) {
            clazz = null;
        }
        return clazz;
    }

    private void postNetState(NetworkState netWorkState) {
        try {
            Set<Object> set = this.netWorkStateChangedMethodMap.keySet();
            for (Object object : set) {
                NetworkStateReceiverMethod NetworkStateReceiverMethod2 = this.netWorkStateChangedMethodMap.get(object);
                this.invokeMethod(NetworkStateReceiverMethod2, netWorkState);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void invokeMethod(NetworkStateReceiverMethod NetworkStateReceiverMethod2, NetworkState netWorkState) {
        if (NetworkStateReceiverMethod2 != null) {
            try {
                NetworkState[] netWorkStates;
                for (NetworkState myState : netWorkStates = NetworkStateReceiverMethod2.getNetworkState()) {
                    if (myState != netWorkState) continue;
                    NetworkStateReceiverMethod2.getMethod().invoke(NetworkStateReceiverMethod2.getObject(), new Object[]{netWorkState});
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private NetworkStateReceiverMethod findMethod(Object object, Class myClass) {
        Method[] methods;
        NetworkStateReceiverMethod targetMethod = null;
        for (Method method : methods = myClass.getDeclaredMethods()) {
            Class<?>[] parameters;
            if (Build.VERSION.SDK_INT >= 26 && method.getParameterCount() != 1 || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].getName().equals(NetworkState.class.getName())) continue;
            NetworkMonitor netWorkMonitor = method.getAnnotation(NetworkMonitor.class);
            targetMethod = new NetworkStateReceiverMethod();
            if (netWorkMonitor != null) {
                NetworkState[] netWorkStates = netWorkMonitor.monitorFilter();
                targetMethod.setNetworkState(netWorkStates);
            }
            targetMethod.setMethod(method);
            targetMethod.setObject(object);
            return targetMethod;
        }
        return targetMethod;
    }

    private static int getAPNType(Context context) {
        if (context == null) {
            return 0;
        }
        int netType = 0;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (manager != null) {
            networkInfo = manager.getActiveNetworkInfo();
        }
        if (networkInfo == null) {
            return netType;
        }
        int nType = networkInfo.getType();
        if (nType == 1) {
            netType = 1;
        } else if (nType == 0) {
            int nSubType = networkInfo.getSubtype();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                netType = nSubType == 13 && !telephonyManager.isNetworkRoaming() ? 4 : (nSubType == 3 || nSubType == 8 || nSubType == 5 && !telephonyManager.isNetworkRoaming() ? 3 : (nSubType == 1 || nSubType == 2 || nSubType == 4 && !telephonyManager.isNetworkRoaming() ? 2 : 2));
            }
        }
        return netType;
    }

    @RequiresApi(api=21)
    private class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private NetworkCallback() {
        }

        public void onAvailable(Network network) {
            NetworkState netWorkState;
            super.onAvailable(network);
            int netType = NetworkMonitorManager.getAPNType(NetworkMonitorManager.this.mContext);
            switch (netType) {
                case 0: {
                    netWorkState = NetworkState.NONE;
                    break;
                }
                case 1: {
                    netWorkState = NetworkState.WIFI;
                    break;
                }
                default: {
                    netWorkState = NetworkState.CELLULAR;
                }
            }
            NetworkMonitorManager.this.postNetState(netWorkState);
        }

        public void onLost(Network network) {
            super.onLost(network);
            NetworkMonitorManager.this.postNetState(NetworkState.NONE);
        }

        public void onLosing(Network network, int maxMsToLive) {
            super.onLosing(network, maxMsToLive);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
        }

        public void onUnavailable() {
            super.onUnavailable();
        }
    }
}

