/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.callback;

import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.client.Callback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;

public class ConnectCallback
implements Callback<Void> {
    private final boolean isFaq;
    private final IMqttCallback callback;
    private final int connectionId;

    public ConnectCallback(boolean isFaq, IMqttCallback callback, int connectionId) {
        this.isFaq = isFaq;
        this.callback = callback;
        this.connectionId = connectionId;
    }

    @Override
    public void onSuccess(Void value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            if (this.isFaq) {
                return;
            }
            MqttConfig.getInstance().setConnected(true);
        }
    }

    @Override
    public void onFailure(final Throwable value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            AIHelpLogger.error("mqtt connect failure", value);
            if (this.isFaq) {
                return;
            }
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (ConnectCallback.this.callback != null) {
                        ConnectCallback.this.callback.onMqttFailure("ConnectCallback " + value.getMessage());
                    }
                }
            });
        }
    }
}

