/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.callback;

import android.os.Handler;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.client.Listener;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.TLog;

public class ReceiveListener
implements Listener {
    private final boolean isFaq;
    private final IMqttCallback callback;
    private final Handler handler;
    private final int connectionId;

    public ReceiveListener(boolean isFaq, IMqttCallback callback, Handler handler, int connectionId) {
        this.isFaq = isFaq;
        this.callback = callback;
        this.handler = handler;
        this.connectionId = connectionId;
    }

    @Override
    public void onConnected() {
        this.callback.onMqttConnected();
    }

    @Override
    public void onDisconnected() {
    }

    @Override
    public void onPublish(UTF8Buffer utf8Buffer, Buffer body, Runnable ack) {
        if (this.isFaq || this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            if (this.callback != null) {
                String[] topicArr = utf8Buffer.toString().split("/");
                final String topic = topicArr[topicArr.length - 1];
                String response = new String(body.toByteArray()).trim();
                if ("login".equals(topic) && this.handler != null) {
                    this.handler.removeCallbacksAndMessages(null);
                }
                TLog.json(String.format("MQTT %s [onResponse] %s", this.toString().replace(this.getClass().getName(), this.getClass().getSimpleName()), topic), response);
                final String finalResponse = response;
                ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ReceiveListener.this.callback.onMqttResponse(MqttConfig.getInstance().getLoginType(), topic, finalResponse);
                    }
                });
            }
            ack.run();
        }
    }

    @Override
    public void onFailure(Throwable value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            MqttConfig.getInstance().setConnected(false);
            AIHelpLogger.error("ReceiveListener onFailure", value);
        }
    }
}

