/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.codec.MQTTFrame;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;

public class PUBREL
extends MessageSupport.HeaderBase
implements MessageSupport.Message,
MessageSupport.Acked {
    public static final byte TYPE = 6;
    private short messageId;

    @Override
    public byte messageType() {
        return 6;
    }

    public PUBREL() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    @Override
    public PUBREL decode(MQTTFrame frame) throws ProtocolException {
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.messageId = is.readShort();
        return this;
    }

    @Override
    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(2);
            os.writeShort(this.messageId);
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(6);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    @Override
    public boolean dup() {
        return super.dup();
    }

    @Override
    public PUBREL dup(boolean dup) {
        return (PUBREL)super.dup(dup);
    }

    @Override
    public QoS qos() {
        return super.qos();
    }

    @Override
    public short messageId() {
        return this.messageId;
    }

    @Override
    public PUBREL messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public String toString() {
        return "PUBREL{dup=" + this.dup() + ", qos=" + (Object)((Object)this.qos()) + ", messageId=" + this.messageId + '}';
    }
}

