/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Arrays;
import net.aihelp.core.net.mqtt.codec.MQTTFrame;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;

public class SUBACK
implements MessageSupport.Message {
    public static final byte[] NO_GRANTED_QOS = new byte[0];
    public static final byte TYPE = 9;
    private short messageId;
    private byte[] grantedQos = NO_GRANTED_QOS;

    @Override
    public byte messageType() {
        return 9;
    }

    @Override
    public SUBACK decode(MQTTFrame frame) throws ProtocolException {
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.messageId = is.readShort();
        this.grantedQos = is.readBuffer(is.available()).toByteArray();
        return this;
    }

    @Override
    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(2 + this.grantedQos.length);
            os.writeShort(this.messageId);
            os.write(this.grantedQos);
            MQTTFrame frame = new MQTTFrame();
            frame.commandType(9);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public byte[] grantedQos() {
        return this.grantedQos;
    }

    public SUBACK grantedQos(byte[] grantedQos) {
        this.grantedQos = grantedQos;
        return this;
    }

    public short messageId() {
        return this.messageId;
    }

    public SUBACK messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public String toString() {
        return "SUBACK{grantedQos=" + Arrays.toString(this.grantedQos) + ", messageId=" + this.messageId + '}';
    }
}

