/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtbuf;

import net.aihelp.core.net.mqtt.hawtbuf.AbstractVarIntSupport;
import net.aihelp.core.net.mqtt.hawtbuf.Buffer;

public abstract class BufferEditor
extends AbstractVarIntSupport {
    protected final Buffer buffer;

    private BufferEditor(Buffer buffer) {
        this.buffer = buffer;
    }

    protected boolean hasCapacity(int len) {
        return this.buffer.length >= len;
    }

    public int read() {
        --this.buffer.length;
        return this.buffer.data[this.buffer.offset++] & 0xFF;
    }

    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) {
        System.arraycopy(this.buffer.data, this.buffer.offset, b, off, len);
        this.buffer.offset += len;
        this.buffer.length -= len;
    }

    public int skipBytes(int n) {
        int len = Math.min(n, this.buffer.length);
        this.buffer.offset += len;
        this.buffer.length -= len;
        return len;
    }

    public boolean readBoolean() {
        return this.read() != 0;
    }

    @Override
    public byte readByte() {
        return (byte)this.read();
    }

    public int readUnsignedByte() {
        return this.read();
    }

    public void write(int b) {
        this.buffer.data[this.buffer.offset++] = (byte)b;
        --this.buffer.length;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buffer.data, this.buffer.offset, len);
        this.buffer.offset += len;
        this.buffer.length -= len;
    }

    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    public abstract short readShort();

    public abstract int readUnsignedShort();

    public abstract char readChar();

    public abstract int readInt();

    public abstract long readLong();

    public abstract double readDouble();

    public abstract float readFloat();

    public abstract void writeShort(int var1);

    public abstract void writeChar(int var1);

    public abstract void writeInt(int var1);

    public abstract void writeLong(long var1);

    public abstract void writeDouble(double var1);

    public abstract void writeFloat(float var1);

    public abstract void writeRawDouble(double var1);

    public abstract void writeRawFloat(float var1);

    public static BufferEditor big(Buffer buffer) {
        return new BigEndianBufferEditor(buffer);
    }

    public static BufferEditor little(Buffer buffer) {
        return new LittleEndianBufferEditor(buffer);
    }

    static class LittleEndianBufferEditor
    extends BufferEditor {
        LittleEndianBufferEditor(Buffer buffer) {
            super(buffer);
        }

        @Override
        public short readShort() {
            return (short)((this.read() << 0) + (this.read() << 8));
        }

        @Override
        public int readUnsignedShort() {
            return (this.read() << 0) + (this.read() << 8);
        }

        @Override
        public char readChar() {
            return (char)((this.read() << 0) + (this.read() << 8));
        }

        @Override
        public int readInt() {
            return (this.read() << 0) + (this.read() << 8) + (this.read() << 16) + (this.read() << 24);
        }

        @Override
        public long readLong() {
            return (long)((this.read() << 0) + (this.read() << 8) + (this.read() << 16)) + ((long)this.read() << 24) + ((long)this.read() << 32) + ((long)this.read() << 40) + ((long)this.read() << 48) + ((long)this.read() << 56);
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public void writeShort(int v) {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }

        @Override
        public void writeChar(int v) {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }

        @Override
        public void writeInt(int v) {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 24 & 0xFF);
        }

        @Override
        public void writeLong(long v) {
            this.write((int)(v >>> 0) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 56) & 0xFF);
        }

        @Override
        public void writeDouble(double v) {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeFloat(float v) {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeRawDouble(double v) {
            this.writeLong(Double.doubleToRawLongBits(v));
        }

        @Override
        public void writeRawFloat(float v) {
            this.writeInt(Float.floatToRawIntBits(v));
        }
    }

    static class BigEndianBufferEditor
    extends BufferEditor {
        BigEndianBufferEditor(Buffer buffer) {
            super(buffer);
        }

        @Override
        public short readShort() {
            return (short)((this.read() << 8) + (this.read() << 0));
        }

        @Override
        public int readUnsignedShort() {
            return (this.read() << 8) + (this.read() << 0);
        }

        @Override
        public char readChar() {
            return (char)((this.read() << 8) + (this.read() << 0));
        }

        @Override
        public int readInt() {
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + (this.read() << 0);
        }

        @Override
        public long readLong() {
            return ((long)this.read() << 56) + ((long)this.read() << 48) + ((long)this.read() << 40) + ((long)this.read() << 32) + ((long)this.read() << 24) + (long)(this.read() << 16) + (long)(this.read() << 8) + (long)(this.read() << 0);
        }

        @Override
        public double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public float readFloat() {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public void writeShort(int v) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeChar(int v) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeInt(int v) {
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        @Override
        public void writeLong(long v) {
            this.write((int)(v >>> 56) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 0) & 0xFF);
        }

        @Override
        public void writeDouble(double v) {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeFloat(float v) {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeRawDouble(double v) {
            this.writeLong(Double.doubleToRawLongBits(v));
        }

        @Override
        public void writeRawFloat(float v) {
            this.writeInt(Float.floatToRawIntBits(v));
        }
    }
}

