/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchPriority;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Metrics;
import net.aihelp.core.net.mqtt.hawtdispatch.ShutdownException;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.HawtDispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.HawtDispatcher;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.SerialDispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.ThreadDispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.WorkerPool;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.WorkerThread;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.pool.SimplePool;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.util.IntrospectionSupport;

public final class GlobalDispatchQueue
implements HawtDispatchQueue {
    public final HawtDispatcher dispatcher;
    volatile String label;
    private final DispatchPriority priority;
    final WorkerPool workers;

    public GlobalDispatchQueue(HawtDispatcher dispatcher, DispatchPriority priority, int threads) {
        this.dispatcher = dispatcher;
        this.priority = priority;
        this.label = priority.toString();
        this.workers = new SimplePool(this, threads, priority);
        dispatcher.track(this);
    }

    public void start() {
        this.workers.start();
    }

    public void shutdown() {
        this.workers.shutdown();
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isExecuting() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.globalQueue == this;
        }
        return false;
    }

    @Override
    public void assertExecuting() {
    }

    @Override
    public LinkedList<Task> getSourceQueue() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.getSourceQueue();
        }
        return null;
    }

    @Override
    @Deprecated
    public void execute(Runnable runnable) {
        this.execute(new TaskWrapper(runnable));
    }

    @Override
    @Deprecated
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.executeAfter(delay, unit, new TaskWrapper(runnable));
    }

    @Override
    public void execute(Task task) {
        if (this.dispatcher.shutdownState.get() > 1) {
            throw new ShutdownException();
        }
        this.workers.execute(task);
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Task task) {
        if (this.dispatcher.shutdownState.get() > 0) {
            throw new ShutdownException();
        }
        this.dispatcher.timerThread.addRelative(task, this, delay, unit);
    }

    @Override
    public ThreadDispatchQueue getTargetQueue() {
        return null;
    }

    public DispatchPriority getPriority() {
        return this.priority;
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GlobalDispatchQueue isGlobalDispatchQueue() {
        return this;
    }

    @Override
    public SerialDispatchQueue isSerialDispatchQueue() {
        return null;
    }

    @Override
    public ThreadDispatchQueue isThreadDispatchQueue() {
        return null;
    }

    public String toString() {
        return IntrospectionSupport.toString(this);
    }

    @Override
    public DispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = this.dispatcher.createQueue(label);
        rc.setTargetQueue(this);
        return rc;
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.GLOBAL_QUEUE;
    }

    DispatchQueue[] getThreadQueues() {
        WorkerThread[] threads = this.workers.getThreads();
        DispatchQueue[] rc = new DispatchQueue[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            rc[i] = threads[i].getDispatchQueue();
        }
        return rc;
    }

    @Override
    public void profile(boolean profile) {
    }

    @Override
    public boolean profile() {
        return false;
    }

    @Override
    public Metrics metrics() {
        return null;
    }
}

