/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import java.lang.reflect.Method;
import java.util.Map;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.monitor.NetworkMonitorManager;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;

public abstract class BaseActivity
extends AppCompatActivity {
    protected Context mContext;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this.getBaseContext();
        if (savedInstanceState != null) {
            Intent launchIntent = AppInfoUtil.getLaunchIntent(this.getApplicationContext(), this.getPackageName());
            if (launchIntent != null) {
                this.finish();
                this.startActivity(launchIntent);
            }
            return;
        }
        this.updateActivityInfoAtRuntime();
        this.setContentView(this.getLayoutId());
        this.initView();
        if (this.isApplyPendingTransition()) {
            this.overridePendingTransition(ResResolver.getAnimId("aihelp_right_in"), ResResolver.getAnimId("aihelp_exit_trans"));
        }
        NetworkMonitorManager.getInstance().register((Object)this);
    }

    public void finish() {
        super.finish();
        if (this.isApplyPendingTransition()) {
            this.overridePendingTransition(0, ResResolver.getAnimId("aihelp_right_out"));
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        try {
            Class<?> splitCompatClass = Class.forName("com.google.android.play.core.splitcompat.SplitCompat");
            Method installActivityMethod = splitCompatClass.getDeclaredMethod("installActivity", Context.class);
            installActivityMethod.setAccessible(true);
            installActivityMethod.invoke(null, this.getBaseContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newConfig.fontScale != 1.0f) {
            this.getResources();
        }
        super.onConfigurationChanged(newConfig);
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (resources.getConfiguration().fontScale != 1.0f) {
            Configuration newConfig = new Configuration();
            newConfig.setToDefaults();
            resources.updateConfiguration(newConfig, resources.getDisplayMetrics());
        }
        return resources;
    }

    protected void onDestroy() {
        super.onDestroy();
        NetworkMonitorManager.getInstance().unregister((Object)this);
    }

    public void onNetworkStateChanged(NetworkState state) {
        if (state == NetworkState.NONE) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
        }
        EventBus.getDefault().post((Object)state);
    }

    public abstract int getLayoutId();

    public void initView() {
    }

    public boolean isApplyPendingTransition() {
        return false;
    }

    protected void attachBaseContext(Context newBase) {
        Context contextWithLocale = AIHelpContext.createContextWithLocale(newBase, Const.CORRECT_LANGUAGE);
        AIHelpContext.getInstance().setContext(contextWithLocale);
        try {
            Class<?> splitCompatClass = Class.forName("com.google.android.play.core.splitcompat.SplitCompat");
            Method installActivityMethod = splitCompatClass.getDeclaredMethod("installActivity", Context.class);
            installActivityMethod.setAccessible(true);
            installActivityMethod.invoke(null, contextWithLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.attachBaseContext(contextWithLocale);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && !Const.isNestedFragmentOnResume) {
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void updateActivityInfoAtRuntime() {
        Map<String, Object> info = Const.sActivityInfo;
        try {
            if (info != null) {
                Object screenOrientation;
                Object theme = info.get("theme");
                if (theme instanceof Integer) {
                    this.setTheme((Integer)theme);
                }
                if ((screenOrientation = info.get("screenOrientation")) instanceof Integer) {
                    this.setRequestedOrientation((Integer)screenOrientation);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Build.VERSION.SDK_INT < 21) {
            AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        }
    }
}

