/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import java.util.Collection;
import java.util.List;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;

public abstract class CommonAdapter<T>
extends MultiItemTypeAdapter<T> {
    protected Context mContext;
    protected int mLayoutId;
    protected LayoutInflater mInflater;

    public CommonAdapter(Context context) {
        super(context);
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.addItemViewDelegate(new ItemViewDelegate<T>(){

            @Override
            public int getItemViewLayoutId() {
                return CommonAdapter.this.itemLayoutId();
            }

            @Override
            public boolean isForViewType(T item, int position) {
                return true;
            }

            @Override
            public void convert(ViewHolder holder, T t, int position) {
                CommonAdapter.this.convert(holder, t, position);
            }

            @Override
            public void onDataSourceUpdated(List<T> data) {
            }
        });
    }

    protected abstract int itemLayoutId();

    protected abstract void convert(ViewHolder var1, T var2, int var3);

    @Override
    public void remove(int position) {
        if (this.mDatas != null && this.mDatas.size() > 0) {
            this.mDatas.remove(position);
            this.notifyItemRemoved(position - 1);
            if (position != this.mDatas.size()) {
                this.notifyItemRangeChanged(position - 1, this.getItemCount() - position);
            }
        }
    }

    @Override
    public List<T> getDataList() {
        return this.mDatas;
    }

    @Override
    public void setDataList(Collection<T> list) {
        this.mDatas.clear();
        this.mDatas.addAll(list);
        this.notifyDataSetChanged();
    }
}

