/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.util.SparseArray;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.ui.dialog.DialogViewHelper;

public class AlertController {
    private AlertDialog mDialog;
    private Window mWindow;
    private DialogViewHelper mViewHelper;

    public AlertController(AlertDialog dialog, Window window) {
        this.mDialog = dialog;
        this.mWindow = window;
    }

    public AlertDialog getDialog() {
        return this.mDialog;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    private void setViewHelper(DialogViewHelper viewHelper) {
        this.mViewHelper = viewHelper;
    }

    public void setText(int viewId, CharSequence text) {
        this.mViewHelper.setText(viewId, text);
    }

    public void setOnClickListener(int viewId, View.OnClickListener listener) {
        this.mViewHelper.setOnClickListener(viewId, listener);
    }

    public void setBackground(int viewId, int resId) {
        this.mViewHelper.setBackground(viewId, resId);
    }

    public <V extends View> V getView(int viewId) {
        return this.mViewHelper.getView(viewId);
    }

    public static class AlertParams {
        public Context mContext;
        public int mThemeResId;
        public boolean mCancelable = false;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public View mView;
        public int mViewLayoutResId;
        public int mCancelViewId;
        public int mSingleConfirmViewId;
        public int mLeftConfirmViewId;
        public int mRightConfirmViewId;
        public SparseArray<CharSequence> mTextArray = new SparseArray();
        public SparseArray<View.OnClickListener> mClickArray = new SparseArray();
        public SparseArray<Integer> mBackgroundResArray = new SparseArray();
        public int mWidth = -2;
        public int mHeight = -2;
        public int mGravity = 17;
        public int mAnimation = 0;
        public int mBottomTextViewId = 0;

        public AlertParams(Context context, int themeResId) {
            this.mContext = context;
            this.mThemeResId = themeResId;
        }

        void apply(AlertController mAlert) {
            int i;
            DialogViewHelper mViewHelper = null;
            if (this.mViewLayoutResId != 0) {
                mViewHelper = new DialogViewHelper(this.mContext, this.mViewLayoutResId);
            }
            if (this.mView != null) {
                mViewHelper = new DialogViewHelper();
                mViewHelper.setContentView(this.mView);
            }
            if (mViewHelper == null) {
                throw new IllegalArgumentException("method setContentView() must be called! ");
            }
            mAlert.getDialog().setContentView(mViewHelper.getContentView());
            mAlert.setViewHelper(mViewHelper);
            for (i = 0; i < this.mTextArray.size(); ++i) {
                mAlert.setText(this.mTextArray.keyAt(i), (CharSequence)this.mTextArray.valueAt(i));
            }
            for (i = 0; i < this.mClickArray.size(); ++i) {
                mAlert.setOnClickListener(this.mClickArray.keyAt(i), (View.OnClickListener)this.mClickArray.valueAt(i));
            }
            for (i = 0; i < this.mBackgroundResArray.size(); ++i) {
                mAlert.setBackground(this.mBackgroundResArray.keyAt(i), (Integer)this.mBackgroundResArray.valueAt(i));
            }
            Window window = mAlert.getWindow();
            window.setGravity(this.mGravity);
            if (this.mAnimation != 0) {
                window.setWindowAnimations(this.mAnimation);
            }
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.width = this.mWidth;
            layoutParams.height = this.mHeight;
            window.setAttributes(layoutParams);
        }
    }
}

