/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.content.Context;
import android.media.ExifInterface;
import android.net.Uri;
import java.io.IOException;
import java.io.InputStream;
import net.aihelp.core.ui.image.ContentStreamRequestHandler;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.Request;
import net.aihelp.core.ui.image.RequestHandler;
import okio.Okio;
import okio.Source;

class FileRequestHandler
extends ContentStreamRequestHandler {
    FileRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request data) {
        return "file".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        Source source = Okio.source((InputStream)this.getInputStream(request));
        return new RequestHandler.Result(null, source, Picasso.LoadedFrom.DISK, 1);
    }

    private static int getFileExifRotation(Uri uri) {
        try {
            ExifInterface exifInterface = new ExifInterface(uri.getPath());
            return exifInterface.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
    }
}

