/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import java.io.IOException;
import java.io.InputStream;
import net.aihelp.core.ui.image.ContentStreamRequestHandler;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.Request;
import net.aihelp.core.ui.image.RequestHandler;
import okio.Okio;
import okio.Source;

class MediaStoreRequestHandler
extends ContentStreamRequestHandler {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    MediaStoreRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request data) {
        Uri uri = data.uri;
        return "content".equals(uri.getScheme()) && "media".equals(uri.getAuthority());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        boolean isVideo;
        ContentResolver contentResolver = this.context.getContentResolver();
        int exifOrientation = MediaStoreRequestHandler.getExifOrientation(contentResolver, request.uri);
        String mimeType = contentResolver.getType(request.uri);
        boolean bl = isVideo = mimeType != null && mimeType.startsWith("video/");
        if (request.hasSize()) {
            Bitmap bitmap;
            PicassoKind picassoKind = MediaStoreRequestHandler.getPicassoKind(request.targetWidth, request.targetHeight);
            if (!isVideo && picassoKind == PicassoKind.FULL) {
                Source source = Okio.source((InputStream)this.getInputStream(request));
                return new RequestHandler.Result(null, source, Picasso.LoadedFrom.DISK, exifOrientation);
            }
            long id2 = ContentUris.parseId((Uri)request.uri);
            BitmapFactory.Options options = MediaStoreRequestHandler.createBitmapOptions(request);
            options.inJustDecodeBounds = true;
            MediaStoreRequestHandler.calculateInSampleSize(request.targetWidth, request.targetHeight, picassoKind.width, picassoKind.height, options, request);
            if (isVideo) {
                int kind = picassoKind == PicassoKind.FULL ? 1 : picassoKind.androidKind;
                bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id2, (int)kind, (BitmapFactory.Options)options);
            } else {
                bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id2, (int)picassoKind.androidKind, (BitmapFactory.Options)options);
            }
            if (bitmap != null) {
                return new RequestHandler.Result(bitmap, null, Picasso.LoadedFrom.DISK, exifOrientation);
            }
        }
        Source source = Okio.source((InputStream)this.getInputStream(request));
        return new RequestHandler.Result(null, source, Picasso.LoadedFrom.DISK, exifOrientation);
    }

    static PicassoKind getPicassoKind(int targetWidth, int targetHeight) {
        if (targetWidth <= PicassoKind.MICRO.width && targetHeight <= PicassoKind.MICRO.height) {
            return PicassoKind.MICRO;
        }
        if (targetWidth <= PicassoKind.MINI.width && targetHeight <= PicassoKind.MINI.height) {
            return PicassoKind.MINI;
        }
        return PicassoKind.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getExifOrientation(ContentResolver contentResolver, Uri uri) {
        try (Cursor cursor = null;){
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
    }

    static enum PicassoKind {
        MICRO(3, 96, 96),
        MINI(1, 512, 384),
        FULL(2, -1, -1);

        final int androidKind;
        final int width;
        final int height;

        private PicassoKind(int androidKind, int width, int height) {
            this.androidKind = androidKind;
            this.width = width;
            this.height = height;
        }
    }
}

