/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.app.Notification;
import android.app.NotificationManager;
import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import net.aihelp.core.ui.image.Action;
import net.aihelp.core.ui.image.Callback;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.Request;
import net.aihelp.core.ui.image.Utils;

abstract class RemoteViewsAction
extends Action<RemoteViewsTarget> {
    final RemoteViews remoteViews;
    final int viewId;
    Callback callback;
    private RemoteViewsTarget target;

    RemoteViewsAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int errorResId, int memoryPolicy, int networkPolicy, Object tag, String key, Callback callback) {
        super(picasso, null, data, memoryPolicy, networkPolicy, errorResId, null, key, tag, false);
        this.remoteViews = remoteViews;
        this.viewId = viewId;
        this.callback = callback;
    }

    @Override
    void complete(Bitmap result, Picasso.LoadedFrom from) {
        this.remoteViews.setImageViewBitmap(this.viewId, result);
        this.update();
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    @Override
    void cancel() {
        super.cancel();
        if (this.callback != null) {
            this.callback = null;
        }
    }

    @Override
    public void error(Exception e) {
        if (this.errorResId != 0) {
            this.setImageResource(this.errorResId);
        }
        if (this.callback != null) {
            this.callback.onError(e);
        }
    }

    @Override
    RemoteViewsTarget getTarget() {
        if (this.target == null) {
            this.target = new RemoteViewsTarget(this.remoteViews, this.viewId);
        }
        return this.target;
    }

    void setImageResource(int resId) {
        this.remoteViews.setImageViewResource(this.viewId, resId);
        this.update();
    }

    abstract void update();

    static class NotificationAction
    extends RemoteViewsAction {
        private final int notificationId;
        private final String notificationTag;
        private final Notification notification;

        NotificationAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int notificationId, Notification notification, String notificationTag, int memoryPolicy, int networkPolicy, String key, Object tag, int errorResId, Callback callback) {
            super(picasso, data, remoteViews, viewId, errorResId, memoryPolicy, networkPolicy, tag, key, callback);
            this.notificationId = notificationId;
            this.notificationTag = notificationTag;
            this.notification = notification;
        }

        @Override
        void update() {
            NotificationManager manager = (NotificationManager)Utils.getService(this.picasso.context, "notification");
            manager.notify(this.notificationTag, this.notificationId, this.notification);
        }
    }

    static class AppWidgetAction
    extends RemoteViewsAction {
        private final int[] appWidgetIds;

        AppWidgetAction(Picasso picasso, Request data, RemoteViews remoteViews, int viewId, int[] appWidgetIds, int memoryPolicy, int networkPolicy, String key, Object tag, int errorResId, Callback callback) {
            super(picasso, data, remoteViews, viewId, errorResId, memoryPolicy, networkPolicy, tag, key, callback);
            this.appWidgetIds = appWidgetIds;
        }

        @Override
        void update() {
            AppWidgetManager manager = AppWidgetManager.getInstance((Context)this.picasso.context);
            manager.updateAppWidget(this.appWidgetIds, this.remoteViews);
        }
    }

    static class RemoteViewsTarget {
        final RemoteViews remoteViews;
        final int viewId;

        RemoteViewsTarget(RemoteViews remoteViews, int viewId) {
            this.remoteViews = remoteViews;
            this.viewId = viewId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteViewsTarget remoteViewsTarget = (RemoteViewsTarget)o;
            return this.viewId == remoteViewsTarget.viewId && this.remoteViews.equals(remoteViewsTarget.remoteViews);
        }

        public int hashCode() {
            return 31 * this.remoteViews.hashCode() + this.viewId;
        }
    }
}

