/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.bus;

import android.os.Looper;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.HandlerPoster;
import net.aihelp.core.util.bus.Poster;

public interface MainThreadSupport {
    public boolean isMainThread();

    public Poster createPoster(EventBus var1);

    public static class AndroidHandlerMainThreadSupport
    implements MainThreadSupport {
        private final Looper looper;

        public AndroidHandlerMainThreadSupport(Looper looper) {
            this.looper = looper;
        }

        @Override
        public boolean isMainThread() {
            return this.looper == Looper.myLooper();
        }

        @Override
        public Poster createPoster(EventBus eventBus) {
            return new HandlerPoster(eventBus, this.looper, 10);
        }
    }
}

