/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.text.Sentence;

public class Match
implements Serializable {
    private static final long serialVersionUID = 8L;
    private final Map<Section, List<String>> sections = new HashMap<Section, List<String>>();
    private ElvaBot callback;
    private Sentence input;
    private Sentence that;
    private Sentence topic;
    private String[] matchPath;

    public Match() {
        this.sections.put(Section.PATTERN, new ArrayList(2));
        this.sections.put(Section.THAT, new ArrayList(2));
        this.sections.put(Section.TOPIC, new ArrayList(2));
    }

    public Match(ElvaBot callback, Sentence input, Sentence that, Sentence topic) {
        this.sections.put(Section.PATTERN, new ArrayList(2));
        this.sections.put(Section.THAT, new ArrayList(2));
        this.sections.put(Section.TOPIC, new ArrayList(2));
        this.callback = callback;
        this.input = input;
        this.that = that;
        this.topic = topic;
        this.setUpMatchPath(input.normalized(), that.normalized(), topic.normalized());
    }

    public Match(Sentence input) {
        this(null, input, Sentence.ASTERISK, Sentence.ASTERISK);
    }

    private void appendWildcard(List<String> section, Sentence source, int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            section.add(0, "");
        } else {
            try {
                section.add(0, source.original(beginIndex, endIndex));
            }
            catch (Exception e) {
                throw new RuntimeException("Source: {\"" + source.getOriginal() + "\", \"" + source.getNormalized() + "\"}\nBegin Index: " + beginIndex + "\nEnd Index: " + endIndex, e);
            }
        }
    }

    private void setUpMatchPath(String[] pattern, String[] that, String[] topic) {
        int m = pattern.length;
        int n = that.length;
        int o = topic.length;
        this.matchPath = new String[m + 1 + n + 1 + o];
        this.matchPath[m] = "<THAT>";
        this.matchPath[m + 1 + n] = "<TOPIC>";
        System.arraycopy(pattern, 0, this.matchPath, 0, m);
        System.arraycopy(that, 0, this.matchPath, m + 1, n);
        System.arraycopy(topic, 0, this.matchPath, m + 1 + n + 1, o);
    }

    public void appendWildcard(int beginIndex, int endIndex) {
        int inputLength = this.input.length();
        if (beginIndex <= inputLength) {
            this.appendWildcard(this.sections.get((Object)Section.PATTERN), this.input, beginIndex, endIndex);
            return;
        }
        endIndex -= inputLength + 1;
        int thatLength = this.that.length();
        if ((beginIndex -= inputLength + 1) <= thatLength) {
            this.appendWildcard(this.sections.get((Object)Section.THAT), this.that, beginIndex, endIndex);
            return;
        }
        endIndex -= thatLength + 1;
        int topicLength = this.topic.length();
        if ((beginIndex -= thatLength + 1) < topicLength) {
            this.appendWildcard(this.sections.get((Object)Section.TOPIC), this.topic, beginIndex, endIndex);
        }
    }

    public String wildcard(Section section, int index) {
        List<String> wildcards = this.sections.get((Object)section);
        return wildcards.get(index - 1);
    }

    public ElvaBot getCallback() {
        return this.callback;
    }

    public void setCallback(ElvaBot callback) {
        this.callback = callback;
    }

    public String[] getMatchPath() {
        return this.matchPath;
    }

    public String getMatchPath(int index) {
        return this.matchPath[index];
    }

    public int getMatchPathLength() {
        return this.matchPath.length;
    }

    public static enum Section {
        PATTERN,
        THAT,
        TOPIC;

    }
}

