/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.Arrays;
import java.util.List;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import org.xml.sax.Attributes;

public class Pattern
implements AIMLElement {
    private String[] pattern;
    private int hashCode;

    public Pattern() {
    }

    public Pattern(String pattern) {
        this.pattern = pattern.trim().split(" ");
        this.hashCode = Arrays.hashCode(this.pattern);
    }

    public Pattern(Attributes attributes) {
    }

    @Override
    public void appendChild(AIMLElement child) {
        String text = child.toString();
        if (this.pattern == null) {
            this.pattern = new String[]{text};
        } else {
            int length = this.pattern.length;
            String[] larger = new String[length + 1];
            System.arraycopy(this.pattern, 0, larger, 0, length);
            larger[length] = text;
            this.pattern = larger;
        }
    }

    @Override
    public void appendChildren(List<AIMLElement> children) {
        StringBuilder builder = new StringBuilder();
        for (AIMLElement child : children) {
            builder.append(child);
        }
        String text = builder.toString().trim();
        this.pattern = text.split(" ");
        this.hashCode = Arrays.hashCode(this.pattern);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Pattern)) {
            return false;
        }
        Pattern compared = (Pattern)obj;
        return Arrays.equals(this.pattern, compared.pattern);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int n = this.pattern.length;
        while (true) {
            buffer.append(this.pattern[i]);
            if (++i >= n) break;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public String[] getElements() {
        return this.pattern;
    }

    public void setElements(String[] pattern) {
        this.pattern = pattern;
        this.hashCode = Arrays.hashCode(pattern);
    }
}

