/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import net.aihelp.core.util.elva.aiml.Text;

public class TemplateElement
implements AIMLElement {
    private static final TemplateElement[] TEMPLATE_ELEMENT_ARRAY = new TemplateElement[0];
    private final List<TemplateElement> children = new LinkedList<TemplateElement>();

    public TemplateElement(Object ... elements) {
        for (Object child : elements) {
            if (child instanceof AIMLElement) {
                this.children.add((TemplateElement)child);
                continue;
            }
            this.children.add(new Text(child.toString()));
        }
    }

    @Override
    public void appendChild(AIMLElement element) {
        this.children.add((TemplateElement)element);
    }

    @Override
    public void appendChildren(List<AIMLElement> elements) {
        for (AIMLElement element : elements) {
            this.children.add((TemplateElement)element);
        }
    }

    public List<TemplateElement> children() {
        return this.children;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TemplateElement)) {
            return false;
        }
        TemplateElement that = (TemplateElement)object;
        return this.children.equals(that.children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public String process(Match match) {
        StringBuilder value = new StringBuilder();
        for (TemplateElement i : this.children) {
            value.append(i.process(match));
        }
        return value.toString();
    }

    public TemplateElement[] getChildren() {
        return this.children.toArray(TEMPLATE_ELEMENT_ARRAY);
    }

    public TemplateElement getChildren(int index) {
        return this.children.get(index);
    }

    public void setChildren(TemplateElement[] elements) {
        this.children.clear();
        this.children.addAll(Arrays.asList(elements));
    }
}

