/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.Arrays;
import java.util.LinkedList;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.TemplateElement;
import net.aihelp.core.util.elva.text.Response;
import org.xml.sax.Attributes;

public class That
extends TemplateElement {
    private static final String[] STRING_ARRAY = new String[0];
    private int responseIndex = 1;
    private int sentenceIndex = 1;

    public That(Attributes attributes) {
        super(new Object[0]);
        String value = attributes.getValue(0);
        if (value == null) {
            return;
        }
        String[] indexes = value.split(",");
        this.responseIndex = Integer.parseInt(indexes[0].trim());
        if (indexes.length > 1) {
            this.sentenceIndex = Integer.parseInt(indexes[1].trim());
        }
    }

    public That(Object ... children) {
        super(children);
    }

    public That(int responseIndex, int sentenceIndex) {
        super(new Object[0]);
        this.responseIndex = responseIndex;
        this.sentenceIndex = sentenceIndex;
    }

    public String[] elements() {
        TemplateElement[] children = this.getChildren();
        LinkedList<String> elements = new LinkedList<String>();
        try {
            int n = children.length;
            for (int i = 0; i < n; ++i) {
                String text = children[i].toString();
                text = text.trim();
                elements.addAll(Arrays.asList(text.split(" ")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elements.toArray(STRING_ARRAY);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof That)) {
            return false;
        }
        That compared = (That)obj;
        return this.responseIndex == compared.responseIndex && this.sentenceIndex == compared.sentenceIndex;
    }

    @Override
    public int hashCode() {
        return this.responseIndex + this.sentenceIndex;
    }

    @Override
    public String process(Match match) {
        if (match == null) {
            return "";
        }
        ElvaBot bot = match.getCallback();
        Context context = bot.getContext();
        Response response = context.getResponses(this.responseIndex - 1);
        return response.getSentences(this.sentenceIndex - 1).trimOriginal();
    }

    public String toString() {
        if (this.children().size() == 0) {
            return "<that index=\"" + this.responseIndex + ", " + this.sentenceIndex + "\"/>";
        }
        StringBuilder builder = new StringBuilder("<that>");
        for (TemplateElement element : this.children()) {
            builder.append(element);
        }
        builder.append("</that>");
        return builder.toString();
    }
}

