/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.aihelp.core.util.elva.config.ConfigException;
import net.aihelp.core.util.elva.config.TokenizerConfig;
import net.aihelp.core.util.elva.text.Tokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TokenizerConfigStream
extends DefaultHandler
implements TokenizerConfig {
    private static final String[] STRING_ARRAY = new String[0];
    private final SAXParser parser;
    private final List<String> splitters = new ArrayList<String>(6);
    private boolean ignoreWhitespace;

    public TokenizerConfigStream() throws ConfigException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public TokenizerConfigStream(InputStream input) throws ConfigException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.parser = factory.newSAXParser();
            this.parse(input);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    @Override
    public void startElement(String namespace, String name, String qname, Attributes attributes) throws SAXException {
        if ("splitter".equals(qname)) {
            this.splitters.add(attributes.getValue(0));
        }
    }

    @Override
    public Tokenizer newInstance() {
        return new Tokenizer(this.splitters());
    }

    public void parse(InputStream input) throws ConfigException {
        try {
            this.splitters.clear();
            this.ignoreWhitespace = true;
            this.parser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    @Override
    public String[] splitters() {
        return this.splitters.toArray(STRING_ARRAY);
    }
}

