/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.parser;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Graphmaster;
import net.aihelp.core.util.elva.aiml.AIMLParser;
import net.aihelp.core.util.elva.parser.ContextParser;
import net.aihelp.core.util.elva.parser.TransformationsParser;
import net.aihelp.core.util.elva.text.Transformations;
import net.aihelp.utils.TLog;

public class ElvaBotParser {
    private AIMLParser aimlParser;
    private ContextParser contParser;
    private TransformationsParser normParser;
    private String appId;
    private String languageId;
    private static Map<String, Map<String, Graphmaster>> mapGraph = new ConcurrentHashMap<String, Map<String, Graphmaster>>();

    public ElvaBotParser() {
        try {
            this.aimlParser = new AIMLParser();
            this.contParser = new ContextParser();
            this.normParser = new TransformationsParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ElvaBotParser(String appId, String languageId) {
        this();
        this.appId = appId;
        this.languageId = languageId;
    }

    public boolean containsGraph() {
        Map<String, Graphmaster> map = mapGraph.get(this.appId);
        return map != null && map.containsKey(this.languageId);
    }

    public static void removeMapGraph(String appId) {
        Map<String, Graphmaster> map = mapGraph.get(appId);
        if (map != null) {
            map.clear();
        }
    }

    private Context newContext(InputStream defaults, InputStream splitters, InputStream substitutions) throws Exception {
        Context context = new Context();
        this.contParser.parse(context, defaults);
        Transformations transformations = this.normParser.parse(splitters, substitutions);
        context.setTransformations(transformations);
        return context;
    }

    private Graphmaster newGraphmaster(InputStream ... aiml) {
        if (aiml == null) {
            return null;
        }
        Graphmaster graphmaster = new Graphmaster();
        this.aimlParser.parse(graphmaster, aiml);
        return graphmaster;
    }

    public void parse(ElvaBot bot, InputStream defaults, InputStream splitters, InputStream substitutions, InputStream ... aiml) {
        try {
            Graphmaster graphmaster;
            Context context = this.newContext(defaults, splitters, substitutions);
            bot.setContext(context);
            Map<String, Graphmaster> map = mapGraph.get(this.appId);
            if (map == null) {
                map = new HashMap<String, Graphmaster>();
                mapGraph.put(this.appId, map);
            }
            if ((graphmaster = map.get(this.languageId)) == null) {
                graphmaster = this.newGraphmaster(aiml);
                map.put(this.languageId, graphmaster);
            }
            bot.setGraphmaster(graphmaster);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ElvaBot parse(InputStream defaults, InputStream splitters, InputStream substitutions, InputStream ... aiml) {
        try {
            ElvaBot bot = new ElvaBot();
            this.parse(bot, defaults, splitters, substitutions, aiml);
            return bot;
        }
        catch (Exception e) {
            TLog.e("ElvaBot parse exception -> " + e.toString());
            return null;
        }
    }
}

