/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.Arrays;
import net.aihelp.core.util.elva.text.Sentence;

public class Request {
    private Sentence[] sentences;
    private String original;

    public Request() {
    }

    public Request(String original) {
        this.original = original;
    }

    public Request(String original, Sentence ... sentences) {
        this.original = original;
        this.sentences = sentences;
    }

    public boolean empty() {
        return this.sentences == null || this.sentences.length == 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Request)) {
            return false;
        }
        Request compared = (Request)obj;
        return this.original.equals(compared.original) && Arrays.equals(this.sentences, compared.sentences);
    }

    public Sentence lastSentence(int index) {
        return this.sentences[this.sentences.length - (1 + index)];
    }

    public String toString() {
        return this.original;
    }

    public String trimOriginal() {
        return this.original.trim();
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }

    public Sentence[] getSentences() {
        return this.sentences;
    }

    public Sentence getSentences(int index) {
        return this.sentences[index];
    }

    public void setSentences(Sentence[] sentences) {
        this.sentences = sentences;
    }
}

