/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.core.util.elva.config.TokenizerConfig;
import net.aihelp.core.util.elva.util.Escaper;

public class Tokenizer {
    private Boolean ignoreWhitespace;
    private String[] splitters;
    private Pattern pattern;

    public Tokenizer() {
    }

    public Tokenizer(String ... splitters) {
        this.setIgnoreWhitespace(true);
        this.setSplitters(splitters);
    }

    public Tokenizer(TokenizerConfig config) {
        this(config.splitters());
    }

    private void afterSetProperty() {
        if (this.splitters == null || this.ignoreWhitespace == null) {
            return;
        }
        String expression = "";
        int i = 0;
        int n = this.splitters.length;
        while (true) {
            expression = expression + Escaper.escapeRegex(this.splitters[i]);
            if (++i >= n) break;
            expression = expression + '|';
        }
        expression = this.ignoreWhitespace != false ? "(" + expression + ")[ \\s]*|[ \\s]+" : "(" + expression + "|[ \\s]+)";
        this.pattern = Pattern.compile(expression);
    }

    public List<String> tokenize(String input) {
        ArrayList<String> output = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(input);
        int beginIndex = 0;
        try {
            while (matcher.find()) {
                String symbol;
                int endIndex = matcher.start();
                String token = input.substring(beginIndex, endIndex);
                if (token.length() > 0) {
                    output.add(token);
                }
                if ((symbol = matcher.group(1)) != null) {
                    output.add(symbol);
                }
                String breaker = matcher.group();
                beginIndex = endIndex + breaker.length();
            }
            if (beginIndex < input.length()) {
                String token = input.substring(beginIndex);
                output.add(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public String toString(List<String> tokens) {
        String output = "";
        int i = 0;
        int n = tokens.size();
        String next = tokens.get(0);
        while (true) {
            output = output + next;
            if (++i >= n) break;
            next = tokens.get(i);
            Matcher matcher = this.pattern.matcher(next);
            if (matcher.matches()) continue;
            output = output + ' ';
        }
        return output;
    }

    public boolean getIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setIgnoreWhitespace(boolean ignore) {
        this.ignoreWhitespace = ignore;
        this.afterSetProperty();
    }

    public String[] getSplitters() {
        return this.splitters;
    }

    public void setSplitters(String[] splitters) {
        this.splitters = splitters;
        this.afterSetProperty();
    }
}

