/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.core.util.elva.text.Request;
import net.aihelp.core.util.elva.text.Sentence;
import net.aihelp.core.util.elva.text.SentenceSplitter;
import net.aihelp.core.util.elva.text.Substitution;
import net.aihelp.core.util.elva.text.Tokenizer;
import net.aihelp.core.util.elva.util.ParseUtil;

public class Transformations {
    private static final Integer[] INTEGER_ARRAY = new Integer[0];
    private final Tokenizer tokenizer;
    private final Pattern fitting = Pattern.compile("[^A-Z0-9\\u4E00-\\u9FA5\\u3040-\\u31FE\\u0400-\\u04FF\\u0E00-\\u0E7F\\uAC00-\\uD7AF\\u0600-\\u06FF\\u0080-\\u00FF\\u0100-\\u017F\\u0B80-\\u0BFF\\u0370-\\u03FF\\u1000-\\u109F\\u1780-\\u17FF]+");
    private final Pattern wordBreakers = Pattern.compile("([,;:])([A-Za-z]|[ \\s]{2,})");
    private final SentenceSplitter splitter;
    private Map<String, String> correction;
    private Map<String, String> protection;
    private List<Substitution> person;
    private List<Substitution> person2;
    private List<Substitution> gender;

    public Transformations(List<String> splitters, Map<String, Map<String, String>> substitutions, Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.splitter = new SentenceSplitter(substitutions.get("protection"), splitters);
        this.correction = substitutions.get("correction");
    }

    private List<Substitution> newSubstitutionList(Map<String, String> inputs) {
        ArrayList<Substitution> subsitutions = new ArrayList<Substitution>(inputs.size());
        for (Map.Entry<String, String> entry : inputs.entrySet()) {
            Substitution substitution = new Substitution(entry.getKey(), entry.getValue(), this.tokenizer);
            subsitutions.add(substitution);
        }
        return subsitutions;
    }

    private String breakWords(String input) {
        Matcher matcher = this.wordBreakers.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String replace = matcher.group(2);
            replace = replace.charAt(0) != ' ' ? matcher.group(1) + ' ' + replace : matcher.group(1) + ' ';
            matcher.appendReplacement(buffer, replace);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String fit(String input) {
        input = input.toUpperCase();
        Matcher matcher = this.fitting.matcher(input);
        return matcher.replaceAll(" ");
    }

    private String fit(String input, Mapper mapper) {
        input = input.toUpperCase();
        Matcher matcher = this.fitting.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (!matcher.hitEnd() && matcher.find()) {
            mapper.prepare(input, matcher.group(), " ");
            mapper.update(matcher.start());
            matcher.appendReplacement(buffer, " ");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String substitute(String input) {
        for (String find : this.correction.keySet()) {
            Pattern pattern = Pattern.compile(find, 66);
            Matcher matcher = pattern.matcher(input);
            String replace = this.correction.get(find);
            input = matcher.replaceAll(replace);
        }
        return input;
    }

    private String substitute(String input, Mapper mapper) {
        StringBuffer buffer = new StringBuffer();
        for (String find : this.correction.keySet()) {
            Pattern pattern = Pattern.compile(find, 66);
            Matcher matcher = pattern.matcher(input);
            String replace = this.correction.get(find);
            mapper.prepare(input, find, replace);
            while (!matcher.hitEnd() && matcher.find()) {
                mapper.update(matcher.start() + 1);
                matcher.appendReplacement(buffer, replace);
            }
            matcher.appendTail(buffer);
            input = buffer.toString();
            buffer.delete(0, buffer.length());
        }
        return input;
    }

    private String transform(String input, List<Substitution> substitutions) {
        List<String> tokens = this.tokenizer.tokenize(input);
        int i = 0;
        block0: while (i < tokens.size()) {
            int offset = i;
            for (Substitution substitution : substitutions) {
                i = substitution.substitute(offset, tokens);
                if (i <= offset) continue;
                continue block0;
            }
            ++i;
        }
        return this.tokenizer.toString(tokens);
    }

    public void normalization(Request request) {
        String original = ' ' + request.getOriginal() + ' ';
        original = original.replaceAll("[ ]{2,}", " ");
        String[] input = this.splitter.split(original);
        Sentence[] sentences = new Sentence[input.length];
        int n = input.length;
        for (int i = 0; i < n; ++i) {
            sentences[i] = new Sentence(input[i]);
            this.normalization(sentences[i]);
        }
        request.setOriginal(original);
        request.setSentences(sentences);
    }

    public void normalization(Sentence sentence) {
        String input = this.breakWords(sentence.getOriginal());
        input = ParseUtil.blankSplit(input);
        input = ' ' + input + ' ';
        input = input.replaceAll("[ ]{2,}", " ");
        sentence.setOriginal(input);
        Mapper mapper = new Mapper(input);
        input = this.substitute(input, mapper);
        input = this.fit(input, mapper);
        sentence.setMappings(mapper.toArray());
        sentence.setNormalized(input);
    }

    public String normalization(String input) {
        input = ' ' + input + ' ';
        input = input.replaceAll("[ ]{2,}", " ");
        input = this.substitute(input);
        input = this.fit(input);
        return input;
    }

    private class Mapper {
        private int charIndex;
        private int listIndex;
        private int spaceCount;
        private final List<Integer> mappings = new LinkedList<Integer>();
        private String input;
        private String find;
        private String replace;

        public Mapper(String input) {
            char[] chars = input.toCharArray();
            int n = chars.length;
            for (int i = 0; i < n; ++i) {
                if (chars[i] != ' ') continue;
                this.mappings.add(i);
            }
        }

        private int spaceCount(String string) {
            return this.spaceCount(string, 0, string.length());
        }

        private int spaceCount(String string, int beginIndex, int endIndex) {
            int spaces = 0;
            char[] chars = string.toCharArray();
            int n = endIndex;
            for (int i = beginIndex; i < n; ++i) {
                if (chars[i] != ' ') continue;
                ++spaces;
            }
            return spaces;
        }

        public void prepare(String input, String find, String replace) {
            this.input = input;
            this.find = find;
            this.replace = replace;
            this.spaceCount = this.spaceCount(find);
            this.listIndex = 0;
            this.charIndex = 0;
        }

        public void update(int beginIndex) {
            this.listIndex += this.spaceCount(this.input, this.charIndex, beginIndex);
            this.charIndex = beginIndex;
            int n = this.spaceCount;
            int m = this.replace.length();
            for (int j = 0; j < m; ++j) {
                if (this.replace.charAt(j) != ' ' || --n >= 0 || this.mappings.size() < this.listIndex) continue;
                this.mappings.add(this.listIndex++, null);
            }
            while (n-- > 0) {
                if (this.mappings.size() <= this.listIndex) continue;
                this.mappings.remove(this.listIndex);
            }
        }

        public Integer[] toArray() {
            return this.mappings.toArray(INTEGER_ARRAY);
        }
    }
}

