/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.logger;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.common.Const;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.controller.LoggerDBController;
import net.aihelp.utils.DeviceInfoUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public enum AIHelpLogger {
    INSTANCE;

    private final String TAG = AIHelpLogger.class.getSimpleName();
    private final LoggerDBController logStorage = LoggerDBController.getInstance();
    private ThreadPoolExecutor threadPoolExecutor;
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARN = 3;

    private AIHelpLogger() {
        if (this.threadPoolExecutor == null) {
            LinkedBlockingQueue<Runnable> logMessagesQueue = new LinkedBlockingQueue<Runnable>();
            this.threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, logMessagesQueue, new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable r) {
                    return new Thread(r, "AIHelpLogger");
                }
            });
        }
    }

    public void log(int logLevel, String message, Throwable tr) {
        this.logMessageToDatabase(logLevel, message, AIHelpLogger.getStackTraceString(tr), System.currentTimeMillis());
    }

    public JSONArray getCachedLogs() {
        return this.logStorage.getCachedLogs();
    }

    public void deleteAllCachedLogs() {
        this.logStorage.deleteAll();
    }

    private void logMessageToDatabase(final int level, final String message, final String stacktrace, final long timeStamp) {
        try {
            this.threadPoolExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    AIHelpLogger.this.logStorage.insert(level, message, stacktrace, timeStamp);
                }
            });
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("Rejected execution of log message : " + message), (Throwable)e);
        }
    }

    private static String getStackTraceString(Throwable throwable) {
        String stacktrace = "";
        if (throwable != null) {
            StringBuilder builder = new StringBuilder();
            String throwableString = Log.getStackTraceString((Throwable)throwable);
            builder.append(throwableString);
            stacktrace = builder.toString();
        }
        return stacktrace;
    }

    public static void fatal(String message, Throwable tr) {
        INSTANCE.log(1, message, tr);
    }

    public static void error(final String message, final Throwable tr) {
        final Matcher matcher = Pattern.compile("(?<=//).*?(?=/)").matcher(message);
        if (matcher.find()) {
            ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

                @Override
                public void run() {
                    JSONObject messageObject = AIHelpLogger.getMessageObject(message);
                    try {
                        InetAddress[] inetAddressArr = InetAddress.getAllByName(matcher.group());
                        if (inetAddressArr != null && inetAddressArr.length > 0) {
                            Object[] ipAddressArr = new String[inetAddressArr.length];
                            for (int i = 0; i < inetAddressArr.length; ++i) {
                                ipAddressArr[i] = inetAddressArr[i].getHostAddress();
                            }
                            messageObject.put("inetAddress", (Object)Arrays.toString(ipAddressArr));
                            INSTANCE.log(2, messageObject.toString(), tr);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        INSTANCE.log(2, messageObject.toString(), tr);
                    }
                }
            });
        } else {
            INSTANCE.log(2, AIHelpLogger.getMessageObject(message).toString(), tr);
        }
    }

    private static JSONObject getMessageObject(String message) {
        JSONObject msgObject = new JSONObject();
        try {
            msgObject.put("origin", (Object)message);
            msgObject.put("language", (Object)Const.ORIGINAL_LANGUAGE);
            msgObject.put("OSVersion", (Object)Build.VERSION.RELEASE);
            msgObject.put("deviceModel", (Object)Build.MODEL);
            msgObject.put("networkType", (Object)DeviceInfoUtil.getInstance().getNetworkType());
            msgObject.put("carrier", (Object)DeviceInfoUtil.getInstance().getCarrierName());
            msgObject.put("countryCode", (Object)DeviceInfoUtil.getInstance().getSimCountryIso());
            msgObject.put("proxyConfig", (Object)DeviceInfoUtil.getInstance().getProxyConfiguration());
            return msgObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return msgObject;
        }
    }
}

