/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.logger;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.db.BaseSQLiteHelper;
import net.aihelp.core.db.DropAndCreateDatabaseHelper;
import net.aihelp.core.db.IDatabaseContract;
import net.aihelp.core.db.IMigrateContract;

public class LoggerDBHelper
extends BaseSQLiteHelper {
    private static final int DB_VERSION = 1;
    private static final String CREATE_LOGGER_TABLE = "CREATE TABLE IF NOT EXISTS LOG_MESSAGES( TIMESTAMP TEXT, MESSAGE TEXT, LEVEL TEXT, STACKTRACE TEXT);";

    public LoggerDBHelper(Context context, IDatabaseContract contract) {
        super(context, contract);
    }

    public static LoggerDBHelper getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        static final LoggerDBHelper INSTANCE = new LoggerDBHelper(AIHelpContext.getInstance().getContext(), new IDatabaseContract(){

            @Override
            public int getDatabaseVersion() {
                return 1;
            }

            @Override
            public String getDatabaseName() {
                return "LoggerDatabase";
            }

            @Override
            public List<String> getCreateTableQueries() {
                return Collections.singletonList(LoggerDBHelper.CREATE_LOGGER_TABLE);
            }

            @Override
            public List<IMigrateContract> getMigratorsForUpgrade(int oldDbVersion) {
                ArrayList<IMigrateContract> contractList = new ArrayList<IMigrateContract>();
                contractList.add(new DropAndCreateDatabaseHelper(this));
                return contractList;
            }

            @Override
            public List<String> getTableNames() {
                return Collections.singletonList("LOG_MESSAGES");
            }

            @Override
            public String getTag() {
                return "AIHelp_DB_FAQ";
            }
        });

        private LazyHolder() {
        }
    }
}

