/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.viewer;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import androidx.appcompat.app.AlertDialog;
import net.aihelp.core.util.viewer.ViewerLayout;

public class ImageViewer
implements DialogInterface.OnShowListener,
DialogInterface.OnKeyListener,
View.OnClickListener {
    private Context context;
    private Dialog transDialog;
    private ViewerLayout rootLayout;
    private boolean shown;

    private ImageViewer(Context context) {
        this.context = context;
        this.createLayout();
        this.createDialog();
    }

    public static ImageViewer getDefault(Context context) {
        return new ImageViewer(context);
    }

    private void createLayout() {
        this.rootLayout = new ViewerLayout(this.context);
        this.rootLayout.setOnChildViewClickedListener(this);
    }

    private void createDialog() {
        this.transDialog = new AlertDialog.Builder(this.context, 0x1030011).setView((View)this.rootLayout).create();
        this.transDialog.setOnShowListener((DialogInterface.OnShowListener)this);
        this.transDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
    }

    public ImageViewer updateImageResource(String imagePath) {
        if (this.rootLayout != null) {
            this.rootLayout.updateImageResource(imagePath);
        }
        return this;
    }

    public ImageViewer updateVideoResource(String videoThumbnail, String videoPath) {
        if (this.rootLayout != null) {
            this.rootLayout.updateImageResource(videoThumbnail);
            this.rootLayout.updateVideoResource(videoPath);
        }
        return this;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        this.transDialog.show();
        this.shown = true;
    }

    public void dismiss() {
        if (this.shown) {
            this.shown = false;
        }
        this.transDialog.dismiss();
    }

    public void onShow(DialogInterface dialog) {
        this.rootLayout.show();
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        this.dismiss();
    }
}

