/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.viewer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.aihelp.core.ui.image.Callback;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.viewer.PhotoView;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;

public class ViewerLayout
extends RelativeLayout {
    private View rootView;
    private String imagePath;
    private PhotoView imageView;
    private String videoPath;
    private VideoView videoView;
    private ProgressBar progressBar;

    public ViewerLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ViewerLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ViewerLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.rootView = LayoutInflater.from((Context)context).inflate(ResResolver.getLayoutId("aihelp_dialog_media_viewer"), (ViewGroup)this);
        this.setGravity(17);
        this.setBackgroundColor(this.getBackgroundColorByAlpha(255.0f));
        this.imageView = (PhotoView)this.rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        this.videoView = (VideoView)this.rootView.findViewById(ResResolver.getViewId("aihelp_video_view"));
        this.videoView.setBackgroundColor(-16777216);
        this.progressBar = (ProgressBar)this.rootView.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                ViewerLayout.this.videoView.start();
                mp.setLooping(true);
                if (Build.VERSION.SDK_INT < 17) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ViewerLayout.this.finishVideoBuffer();
                        }
                    }, 1000L);
                }
            }
        });
        if (Build.VERSION.SDK_INT >= 17) {
            this.videoView.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                public boolean onInfo(MediaPlayer mp, int what, int extra) {
                    if (what == 3) {
                        ViewerLayout.this.finishVideoBuffer();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void finishVideoBuffer() {
        this.videoView.seekTo(0);
        this.progressBar.setVisibility(8);
        this.imageView.setVisibility(8);
        this.videoView.setBackgroundColor(0);
    }

    public void show() {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            if (!TextUtils.isEmpty((CharSequence)this.videoPath)) {
                this.imageView.enableGesture(false);
                this.videoView.setVisibility(0);
                this.videoView.setVideoPath(this.videoPath);
            } else {
                this.videoView.setVisibility(8);
            }
            Picasso.get().load(this.imagePath).into((ImageView)this.imageView, new Callback(){

                @Override
                public void onSuccess() {
                    if (TextUtils.isEmpty((CharSequence)ViewerLayout.this.videoPath)) {
                        ViewerLayout.this.progressBar.setVisibility(8);
                    }
                }

                @Override
                public void onError(Exception e) {
                    if (TextUtils.isEmpty((CharSequence)ViewerLayout.this.videoPath)) {
                        ViewerLayout.this.progressBar.setVisibility(8);
                    }
                }
            });
        }
    }

    int getBackgroundColorByAlpha(float alpha) {
        int bgColor = -16777216;
        return Color.argb((int)Math.round(alpha), (int)Color.red((int)bgColor), (int)Color.green((int)bgColor), (int)Color.blue((int)bgColor));
    }

    public void updateImageResource(String imagePath) {
        this.imagePath = DomainSupportHelper.correctDomain(imagePath);
    }

    public void updateVideoResource(String videoPath) {
        this.videoPath = DomainSupportHelper.correctDomain(videoPath);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void setOnChildViewClickedListener(View.OnClickListener onClickListener) {
        if (this.rootView != null) {
            this.rootView.setOnClickListener(onClickListener);
        }
        if (this.imageView != null) {
            this.imageView.setOnClickListener(onClickListener);
        }
    }
}

