/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.model.init.InitEntity;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.LocaleUtil;

public class InitRepository
extends AbsRepository {
    public InitRepository(Context context) {
        super(context);
    }

    public void saveDAULogTime(long logTime) {
        this.doSave("sp_log_dau_time", logTime);
    }

    public void prepareInitData(InitEntity initEntity, String initResponse, long lastInitTime) {
        String[] faqMqtt;
        int cachePeriod = initEntity.getRequestLimit();
        String spPrefix = String.format("%s_%s_", Const.APP_ID, Const.ORIGINAL_LANGUAGE);
        this.doSave(spPrefix + "init_limit", cachePeriod < 0 ? cachePeriod : cachePeriod * 60 * 1000);
        this.doSave(spPrefix + "init_response", initResponse);
        this.doSave(spPrefix + "init_timestamp", lastInitTime);
        API.CDN_URL = initEntity.getCdnUrl();
        API.FAQ_URL = initEntity.getFaqdata();
        API.OP_URL = initEntity.getFaqYYdata();
        API.UPLOAD_URL = initEntity.getUpload();
        API.UPLOAD_VIDEO_URL = initEntity.getUploadVideo();
        API.UPLOAD_FILE_URL = initEntity.getUploadLog();
        API.M_FAQ_URL = initEntity.getShowfaq();
        API.LOG_COUNT_URL = initEntity.getPoint();
        API.LOCALE_FILE_URL = initEntity.getLocaleFile();
        API.CONFIG_STYLE_SHEET_URL = initEntity.getConfigStyle();
        API.CONFIG_BUSINESS_LOGIC_URL = initEntity.getConfigBusiness();
        API.CONFIG_OPINION_URL = initEntity.getSatisfyFeedback();
        API.CONFIG_FAQ_HOT_TOPIC_URL = initEntity.getConfigFaq();
        API.CONFIG_PROCESS_URL = initEntity.getConfigProcess();
        API.CONFIG_TEXT_URL = initEntity.getConfigText();
        API.MQTT_IP = initEntity.getSvrip();
        API.MQTT_PORT = initEntity.getSvrport();
        API.MQTT_TOPIC = initEntity.getTopic();
        if (!TextUtils.isEmpty((CharSequence)initEntity.getPushServer()) && (faqMqtt = initEntity.getPushServer().split(":")).length == 2) {
            API.MQTT_FAQ_IP = faqMqtt[0];
            API.MQTT_FAQ_PORT = faqMqtt[1];
        }
        Const.TOGGLE_UPLOAD_VIDEO = initEntity.isOpenVideoUpload();
        Const.TOGGLE_CRM_TOKEN = initEntity.isSetCrmToken();
        Const.TOGGLE_OPEN_FAQ_NOTIFICATION = initEntity.isOpenPushServer();
        Const.TOGGLE_OPEN_UNREAD_MSG = initEntity.isUnreadMessage();
        Const.TOGGLE_UPLOAD_LOG = initEntity.isOpenUploadLogFile();
        Const.TOGGLE_LOCALIZE_VIA_INIT = initEntity.isLocalizeFAQViaInit();
        Const.TOGGLE_MQTT_TLS = initEntity.isTls();
        Const.TOGGLE_TRANSLATE_CS_MESSAGE = initEntity.isTranslates();
        Const.FAQ_FILE = initEntity.getFaqFileName();
        Const.STORY_FILE = initEntity.getStoryAimlFileName();
        Const.OP_FILE = initEntity.getOperateFileName();
        Const.LIMIT_CHECKING_UNREAD = initEntity.getUnreadMessageTime();
        Const.LIMIT_UPLOADING_VIDEO = initEntity.getVideoUploadSizeLimit();
        Const.APP_SHOW_NAME = AppInfoUtil.getAppName(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)initEntity.getCorrectLanguage())) {
            Const.CORRECT_LANGUAGE = initEntity.getCorrectLanguage();
        }
        if (initEntity.getNetworkCheckSetting() != null) {
            Const.TOGGLE_NET_CHECK = true;
            Const.NET_TRACE_ROUTE = initEntity.getNetworkCheckSetting().getTraceroute();
            Const.NET_PING = initEntity.getNetworkCheckSetting().getPing();
        }
        LocalizeHelper.goFetchLocalizeData(this.mContext);
        Log.e((String)"AIHelp", (String)"AIHelp is now ready to help you have conversations with your users!");
    }

    public void saveInitConfig(String appKey, String domain, String appId, String initLanguage) {
        Const.APP_KEY = appKey;
        API.HOST_URL = DomainSupportHelper.getCorrectDomain(domain);
        Const.APP_ID = appId;
        if (!TextUtils.isEmpty((CharSequence)initLanguage)) {
            Const.ORIGINAL_LANGUAGE = LocaleUtil.getFormatLanguage(initLanguage);
        }
        Const.CORRECT_LANGUAGE = Const.ORIGINAL_LANGUAGE;
        UserProfile.USER_ID = DeviceUuidFactory.id(this.mContext);
        UserProfile.SERVER_ID = "-1";
        UserProfile.USER_NAME = "anonymous";
    }

    public void saveUserProfileConfig(UserConfig config) {
        UserProfile.CUSTOM_DATA = config.getFormatCustomData();
        UserProfile.USER_ID = config.getUserId();
        UserProfile.USER_NAME = config.getUserName();
        UserProfile.SERVER_ID = config.getServerId();
    }

    public void updateConversationFields(String welcomeMsg, String storyNode) {
        Const.CUSTOM_WELCOME_MSG = welcomeMsg;
        Const.CUSTOM_STORY_NODE = storyNode;
    }

    public void setUploadLogPath(String logPath) {
        Const.LOG_UPLOAD_PATH = logPath;
    }

    public void setNetworkCheckHostAddress(String hostAddress) {
        Const.NET_CHECK_HOST = hostAddress;
    }

    public void saveCrmInfo(String userId, String userTags) {
        this.doSave("crmInfo_" + userId, String.format("%s|%s", userId, userTags));
    }

    public void saveMqttPushInfo(String pushToken, int pushPlatform) {
        Const.PUSH_INFO = String.format("%s|%s", pushToken, pushPlatform);
    }
}

