/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.data;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aihelp.common.Const;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public enum FaqHelper {
    INSTANCE;

    public static final String FAQ_NOTIFICATION = "faqNotification";
    public static final String FAQ_HOT_TOPICS = "faqHotTopics";
    private static boolean isDataSourcePrepared;
    private JSONArray rawFlatFaqArray = new JSONArray();
    private Map<String, JSONArray> rawFaqMap = new HashMap<String, JSONArray>();
    private List<FaqListEntity> rootSections = new ArrayList<FaqListEntity>();
    private Map<String, List<FaqListEntity>> subSectionsMap = new HashMap<String, List<FaqListEntity>>();
    private Map<String, List<FaqListEntity>> faqQuestionsMap = new HashMap<String, List<FaqListEntity>>();

    public static boolean isFaqDataAlreadyPrepared() {
        return LocalizeUtil.isAlreadyLocalized(1001) && isDataSourcePrepared;
    }

    public JSONArray getRawFlatFaqArray() {
        return this.rawFlatFaqArray;
    }

    public JSONArray getRawNotification() {
        return this.rawFaqMap.get(FAQ_NOTIFICATION);
    }

    public JSONArray getRawHotTopics() {
        return this.rawFaqMap.get(FAQ_HOT_TOPICS);
    }

    public List<FaqListEntity> getRootSections() {
        return this.rootSections;
    }

    public List<FaqListEntity> getSubSections(String sectionId) {
        return this.subSectionsMap.get(sectionId);
    }

    public List<FaqListEntity> getQuestionList(String sectionId) {
        return this.faqQuestionsMap.get(sectionId);
    }

    public void reset() {
        this.rawFaqMap.clear();
        this.rawFlatFaqArray = new JSONArray();
        this.rootSections.clear();
        this.subSectionsMap.clear();
        this.faqQuestionsMap.clear();
        Const.FAQ_FILE = "";
        isDataSourcePrepared = false;
    }

    public synchronized void prepareDataSource() {
        this.prepareDataSource(null);
    }

    public synchronized void prepareDataSource(final Runnable callback) {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1001));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONArray rawSectionArray = JsonHelper.getJsonArray(new JSONObject(content), "faqlist");
                this.prepareRootSectionList(rawSectionArray);
                this.prepareSubSectionsMap(rawSectionArray);
                this.prepareFaqQuestionsMap(rawSectionArray);
                this.flatRawFaqJsonArray(rawSectionArray);
            }
            if (callback != null) {
                ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.run();
                    }
                });
            }
            isDataSourcePrepared = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void prepareNotificationAndHotTopics() {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1009));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONObject jsonObject = new JSONObject(content);
                JSONArray notificationArray = JsonHelper.getJsonArray(jsonObject, "notice");
                ArrayList<FaqListEntity> notificationQuestions = new ArrayList<FaqListEntity>();
                for (int i = 0; i < notificationArray.length(); ++i) {
                    JSONObject faq = JsonHelper.getJsonObject(notificationArray, i);
                    notificationQuestions.add(this.getFaqListEntity(5, faq));
                    faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                    this.rawFlatFaqArray.put((Object)faq);
                }
                this.faqQuestionsMap.put(FAQ_NOTIFICATION, notificationQuestions);
                this.rawFaqMap.put(FAQ_NOTIFICATION, notificationArray);
                JSONArray faqListArray = JsonHelper.getJsonArray(jsonObject, "faqList");
                ArrayList<FaqListEntity> hotTopicQuestions = new ArrayList<FaqListEntity>();
                for (int i = 0; i < faqListArray.length(); ++i) {
                    JSONObject faq = JsonHelper.getJsonObject(faqListArray, i);
                    hotTopicQuestions.add(this.getFaqListEntity(6, faq));
                    faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                    this.rawFlatFaqArray.put((Object)faq);
                }
                this.faqQuestionsMap.put(FAQ_HOT_TOPICS, hotTopicQuestions);
                this.rawFaqMap.put(FAQ_HOT_TOPICS, faqListArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FaqContentEntity getFaqById(String faqId) {
        return this.getFaqById(null, faqId);
    }

    public FaqContentEntity getFaqById(String sectionId, String faqId) {
        if (TextUtils.isEmpty((CharSequence)sectionId)) {
            return this.filterFaqById(this.rawFlatFaqArray, faqId);
        }
        return this.filterFaqById(this.rawFaqMap.get(sectionId), faqId);
    }

    public void afterFaqEvaluated(String faqId) {
        if (TextUtils.isEmpty((CharSequence)faqId)) {
            return;
        }
        String evaluatedFaqIds = SpUtil.getInstance().getString(this.getLanguageBasedKey("evaluated_faqIds"));
        SpUtil.getInstance().put(this.getLanguageBasedKey("evaluated_faqIds"), String.format("%s,%s", evaluatedFaqIds, faqId));
    }

    public boolean shouldShowQuestionFooter(String faqId) {
        if (TextUtils.isEmpty((CharSequence)faqId)) {
            return false;
        }
        return !SpUtil.getInstance().getString(this.getLanguageBasedKey("evaluated_faqIds")).contains(faqId);
    }

    private void flatRawFaqJsonArray(JSONArray rawSectionArray) {
        try {
            for (int i = 0; i < rawSectionArray.length(); ++i) {
                JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
                JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
                if (faqs.length() <= 0) continue;
                for (int j = 0; j < faqs.length(); ++j) {
                    JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                    faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                    this.rawFlatFaqArray.put((Object)faq);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean shouldIgnoreCurrentEntity(FaqListEntity entity) {
        if (entity == null) {
            return true;
        }
        for (int j = 0; j < this.rootSections.size(); ++j) {
            FaqListEntity listEntity = this.rootSections.get(j);
            if (!listEntity.getId().equals(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void prepareRootSectionList(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            FaqListEntity entity;
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0) continue;
            String sectionBName = section.optString("sectionBName");
            if (!TextUtils.isEmpty((CharSequence)sectionBName)) {
                entity = new FaqListEntity(1, section.optString("sectionBId"), section.optString("sectionBName"));
                entity.setOrder(Integer.parseInt(section.optString("sectionBOrderNo")));
                entity.setIconUrl(section.optString("secParentImgUrl"));
            } else {
                entity = new FaqListEntity(1, section.optString("sectionId"), section.optString("sectionName"));
                entity.setOrder(Integer.parseInt(section.optString("orderNo")));
                entity.setIconUrl(section.optString("secImgUrl"));
            }
            if (this.shouldIgnoreCurrentEntity(entity)) continue;
            this.rootSections.add(entity);
        }
        Collections.sort(this.rootSections);
    }

    private boolean isDuplicate(List<FaqListEntity> subSections, String sectionId) {
        for (int i = 0; i < subSections.size(); ++i) {
            FaqListEntity faqListEntity = subSections.get(i);
            if (faqListEntity == null || !faqListEntity.getId().equals(sectionId)) continue;
            return true;
        }
        return false;
    }

    public void prepareSubSectionsMap(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0) continue;
            String parentSectionId = section.optString("sectionBId");
            String parentSectionName = section.optString("sectionBName");
            if (TextUtils.isEmpty((CharSequence)parentSectionName)) continue;
            List<FaqListEntity> subSections = this.subSectionsMap.get(parentSectionId);
            if (subSections == null) {
                subSections = new ArrayList<FaqListEntity>();
            }
            if (this.isDuplicate(subSections, section.optString("sectionId"))) continue;
            FaqListEntity entity = new FaqListEntity(2, section.optString("sectionId"), section.optString("sectionName"));
            entity.setIconUrl(section.optString("secImgUrl"));
            subSections.add(entity);
            this.subSectionsMap.put(parentSectionId, subSections);
        }
    }

    public boolean hasSubsections(String sectionId) {
        return this.subSectionsMap != null && this.subSectionsMap.containsKey(sectionId);
    }

    private void prepareFaqQuestionsMap(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0) continue;
            String sectionId = section.optString("sectionId");
            List<FaqListEntity> faqQuestions = this.faqQuestionsMap.get(sectionId);
            if (faqQuestions == null) {
                faqQuestions = new ArrayList<FaqListEntity>();
            }
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                faqQuestions.add(this.getFaqListEntity(3, faq));
            }
            this.faqQuestionsMap.put(sectionId, faqQuestions);
            this.rawFaqMap.put(sectionId, faqs);
        }
    }

    private FaqContentEntity filterFaqById(JSONArray faqs, String faqId) {
        if (faqs != null && faqs.length() > 0) {
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                String displayId = faq.optString("faqId");
                String mainId = faq.optString("kmMainid");
                String contentId = faq.optString("kmContentId");
                if (!displayId.equals(faqId) && !mainId.equals(faqId) && !contentId.equals(faqId)) continue;
                return this.getFaqContentEntity(faq);
            }
        }
        return null;
    }

    private FaqListEntity getFaqListEntity(int displayType, JSONObject faq) {
        FaqListEntity entity = new FaqListEntity(displayType, faq.optString("kmMainid"), faq.optString("question"));
        entity.setIconUrl(JsonHelper.optString(faq, "imgUrl"));
        return entity;
    }

    private FaqContentEntity getFaqContentEntity(JSONObject faq) {
        FaqContentEntity faqEntity = new FaqContentEntity();
        faqEntity.setFaqMainId(faq.optString("kmMainid"));
        faqEntity.setFaqDisplayId(faq.optString("faqId"));
        faqEntity.setFaqContentId(faq.optString("kmContentId"));
        faqEntity.setFaqTitle(faq.optString("question"));
        faqEntity.setFaqKeywords(faq.optString("keyWords"));
        faqEntity.setSimilarQuestions(faq.optString("similarQuestions"));
        faqEntity.setFaqContent(faq.optString("content"));
        faqEntity.setFaqNoHtmlContent(Styles.getNoTemplateFaqContent(faq.optString("content")));
        return faqEntity;
    }

    private String getLanguageBasedKey(String spKey) {
        return String.format("%s_%s_%s", Const.APP_ID, Const.ORIGINAL_LANGUAGE, spKey);
    }
}

