/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.data;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aihelp.common.Const;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.data.model.op.OperateSection;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.SpUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public enum OperateHelper {
    INSTANCE;

    private String historicArticles = "";
    private JSONArray latelyFlatArticles = new JSONArray();
    private Map<String, JSONArray> rawArticleMap = new HashMap<String, JSONArray>();
    private List<OperateSection> rootSections = new ArrayList<OperateSection>();
    private Map<String, List<OperateArticle>> opArticlesMap = new HashMap<String, List<OperateArticle>>();

    public List<OperateSection> getOperateSections() {
        return this.rootSections;
    }

    public List<OperateArticle> getOperateArticles(String sectionId) {
        return this.opArticlesMap.get(sectionId);
    }

    public synchronized void prepareHistoricDataSource() {
        if (Const.sOperationUnreadListener != null) {
            try {
                String filePath;
                String cacheContent;
                String lastCachedOpFile = SpUtil.getInstance().getString(this.getLanguageBasedKey("last_cached_operate_file"));
                if (!lastCachedOpFile.equals(Const.OP_FILE) && !TextUtils.isEmpty((CharSequence)(cacheContent = FileUtil.getContentFromFile(filePath = LocalizeUtil.getFileLocation(1002, lastCachedOpFile))))) {
                    JSONArray cacheSectionArray = JsonHelper.getJsonArray(new JSONObject(cacheContent), "faqlist");
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < cacheSectionArray.length(); ++i) {
                        JSONObject section = JsonHelper.getJsonObject(cacheSectionArray, i);
                        JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
                        if (faqs.length() <= 0) continue;
                        for (int j = 0; j < faqs.length(); ++j) {
                            JSONObject article = JsonHelper.getJsonObject(faqs, j);
                            builder.append(article.optString("kmMainid")).append(",").append(article.optString("lastUpdateTime")).append("|");
                        }
                    }
                    this.historicArticles = builder.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() {
        this.rootSections.clear();
        this.opArticlesMap.clear();
        Const.OP_FILE = "";
    }

    public synchronized void prepareDataSource() {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1002));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONArray rawSectionArray = JsonHelper.getJsonArray(new JSONObject(content), "faqlist");
                this.prepareRootSectionList(rawSectionArray);
                this.prepareSectionToArticlesMap(rawSectionArray);
                this.flatRawArticleJsonArray(rawSectionArray);
                this.tryToFindUpdatedArticles();
                SpUtil.getInstance().put(this.getLanguageBasedKey("last_cached_operate_file"), Const.OP_FILE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void tryToFindUpdatedArticles() {
        if (Const.sOperationUnreadListener != null) {
            String unreadArticles;
            if (!TextUtils.isEmpty((CharSequence)this.historicArticles)) {
                StringBuilder unreadArticlesBuilder = new StringBuilder();
                for (int i = 0; i < this.latelyFlatArticles.length(); ++i) {
                    JSONObject latestArticle = JsonHelper.getJsonObject(this.latelyFlatArticles, i);
                    String id2 = latestArticle.optString("kmMainid");
                    String updateTime = latestArticle.optString("lastUpdateTime");
                    if (this.historicArticles.contains(id2 + "," + updateTime)) continue;
                    unreadArticlesBuilder.append(id2).append(",");
                }
                SpUtil.getInstance().put(this.getLanguageBasedKey("unread_articles"), unreadArticlesBuilder.toString());
            }
            Const.sOperationUnreadListener.onOperationUnreadChanged(!TextUtils.isEmpty((CharSequence)(unreadArticles = SpUtil.getInstance().getString(this.getLanguageBasedKey("unread_articles"))).toString()));
        }
    }

    public OperateArticle getArticleById(String faqId) {
        return this.getArticleById(null, faqId);
    }

    public OperateArticle getArticleById(String sectionId, String faqId) {
        if (TextUtils.isEmpty((CharSequence)sectionId)) {
            return this.filterFaqById(this.latelyFlatArticles, faqId);
        }
        return this.filterFaqById(this.rawArticleMap.get(sectionId), faqId);
    }

    public void updateOperateFaqUnreadStatus(String articleId) {
        if (TextUtils.isEmpty((CharSequence)articleId)) {
            return;
        }
        String unreadArticles = SpUtil.getInstance().getString(this.getLanguageBasedKey("unread_articles"));
        unreadArticles = unreadArticles.replace(articleId + ",", "");
        SpUtil.getInstance().put(this.getLanguageBasedKey("unread_articles"), unreadArticles);
    }

    public boolean haveUnreadArticles() {
        String unreadArticles = SpUtil.getInstance().getString(this.getLanguageBasedKey("unread_articles"));
        return !TextUtils.isEmpty((CharSequence)unreadArticles);
    }

    public boolean isSectionUnread(String sectionId) {
        if (TextUtils.isEmpty((CharSequence)sectionId)) {
            return false;
        }
        List<OperateArticle> operateArticles = this.opArticlesMap.get(sectionId);
        if (operateArticles != null) {
            for (OperateArticle operateArticle : operateArticles) {
                if (!this.isArticleUnread(operateArticle.getFaqMainId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isArticleUnread(String articleId) {
        if (TextUtils.isEmpty((CharSequence)articleId)) {
            return false;
        }
        String unreadArticles = SpUtil.getInstance().getString(this.getLanguageBasedKey("unread_articles"));
        return unreadArticles.contains(articleId);
    }

    public void afterArticleEvaluated(String articleId) {
        if (TextUtils.isEmpty((CharSequence)articleId)) {
            return;
        }
        String evaluatedFaqIds = SpUtil.getInstance().getString(this.getLanguageBasedKey("evaluated_articleIds"));
        SpUtil.getInstance().put(this.getLanguageBasedKey("evaluated_articleIds"), String.format("%s,%s", evaluatedFaqIds, articleId));
    }

    public boolean shouldShowArticleFooter(String articleId) {
        if (TextUtils.isEmpty((CharSequence)articleId)) {
            return false;
        }
        return !SpUtil.getInstance().getString(this.getLanguageBasedKey("evaluated_articleIds")).contains(articleId);
    }

    private void flatRawArticleJsonArray(JSONArray rawSectionArray) {
        try {
            this.latelyFlatArticles = new JSONArray();
            for (int i = 0; i < rawSectionArray.length(); ++i) {
                JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
                JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
                if (faqs.length() <= 0) continue;
                for (int j = 0; j < faqs.length(); ++j) {
                    this.latelyFlatArticles.put((Object)JsonHelper.getJsonObject(faqs, j));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean shouldIgnoreCurrentEntity(OperateSection entity) {
        if (entity == null) {
            return true;
        }
        for (int j = 0; j < this.rootSections.size(); ++j) {
            OperateSection listEntity = this.rootSections.get(j);
            if (!listEntity.getId().equals(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void prepareRootSectionList(JSONArray rawSectionArray) {
        this.rootSections = new ArrayList<OperateSection>();
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            OperateSection entity;
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0 || this.shouldIgnoreCurrentEntity(entity = new OperateSection(section.optString("sectionId"), section.optString("sectionName"), Integer.parseInt(section.optString("orderNo"))))) continue;
            this.rootSections.add(entity);
        }
        Collections.sort(this.rootSections);
    }

    private void prepareSectionToArticlesMap(JSONArray rawSectionArray) {
        this.opArticlesMap = new HashMap<String, List<OperateArticle>>();
        this.rawArticleMap = new HashMap<String, JSONArray>();
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0) continue;
            String sectionId = section.optString("sectionId");
            List<OperateArticle> faqQuestions = this.opArticlesMap.get(sectionId);
            if (faqQuestions == null) {
                faqQuestions = new ArrayList<OperateArticle>();
            }
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject article = JsonHelper.getJsonObject(faqs, j);
                faqQuestions.add(this.getOperateArticle(article));
            }
            this.opArticlesMap.put(sectionId, faqQuestions);
            this.rawArticleMap.put(sectionId, faqs);
        }
    }

    private OperateArticle filterFaqById(JSONArray articles, String faqId) {
        if (articles != null && articles.length() > 0) {
            for (int j = 0; j < articles.length(); ++j) {
                JSONObject article = JsonHelper.getJsonObject(articles, j);
                String mainId = article.optString("kmMainid");
                String contentId = article.optString("kmContentId");
                if (!mainId.equals(faqId) && !contentId.equals(faqId)) continue;
                return this.getOperateArticle(article);
            }
        }
        return null;
    }

    private OperateArticle getOperateArticle(JSONObject article) {
        OperateArticle articleEntity = new OperateArticle();
        articleEntity.setFaqMainId(article.optString("kmMainid"));
        articleEntity.setFaqContentId(article.optString("kmContentId"));
        articleEntity.setFaqTitle(article.optString("question"));
        articleEntity.setFaqContent(article.optString("content"));
        articleEntity.setFaqImageUrl(article.optString("imgUrl"));
        articleEntity.setFaqUpdateDate(article.optString("lastUpdateDate"));
        return articleEntity;
    }

    private String getLanguageBasedKey(String spKey) {
        return String.format("%s_%s_%s", Const.APP_ID, Const.ORIGINAL_LANGUAGE, spKey);
    }
}

