/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.check.Ping;
import net.aihelp.core.net.check.TraceRoute;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.local.ElvaRepository;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.logic.MqttPresenter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.storyline.BotTag;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.db.bot.ConversationDBHelper;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;
import org.json.JSONObject;

public class ElvaBotPresenter
extends MqttPresenter<BaseCSFragment, ElvaRepository> {
    private boolean isLocalElvaReplied;

    public ElvaBotPresenter(Context context) {
        super(context);
    }

    public void prepareMqttConnection(IMqttCallback callback) {
        callback.showMqttLoading();
        if (TextUtils.isEmpty((CharSequence)Const.CUSTOM_STORY_NODE) && LocalizeUtil.isAIMLLocalized() && !this.isLocalElvaReplied) {
            ArrayList<ConversationMsg> list = new ArrayList<ConversationMsg>();
            ElvaBotMsg defaultMsg = ConversationHelper.getDefaultMsg();
            if (!defaultMsg.isBotStupid()) {
                list.add(defaultMsg);
                Const.isLocalWelcomeAvailable = true;
            }
            ConversationDBHelper.clearElvaMsg();
            ((BaseCSFragment)this.mView).updateChatList(list);
            this.isLocalElvaReplied = true;
        }
        if (this.isNetworkAvailable()) {
            callback.updateHostView((Fragment)this.mView);
            AIHelpMqtt.getInstance().prepare(1, callback);
        } else {
            ((BaseCSFragment)this.mView).showError(ResResolver.getString("aihelp_network_no_connect"));
        }
    }

    public void askForAnswer(String msg) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", (Object)msg);
            jsonObject.put("answer_type", (Object)"wildcard");
            this.mqtt("alice.message.chat", jsonObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void markWhetherFaqHelpful(boolean helpful, ElvaBotMsg botMsg) {
        try {
            JSONObject faqFeedback = new JSONObject();
            faqFeedback.put("isLike", (Object)(helpful ? "1" : "2"));
            faqFeedback.put("timeMillis", botMsg.getTimeStamp());
            faqFeedback.put("isClickDetail", botMsg.isFaqViewed());
            faqFeedback.put("contentId", (Object)botMsg.getFaqContentId());
            this.mqtt("alice.faq.like", faqFeedback);
            if (!helpful && CustomConfig.CustomerService.isUnhelpfulFaqStoryNodeEnable) {
                this.askForAnswer("UnhelpfulFaqStoryNode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postFeedbackOnFaq(ElvaBotMsg botMsg, String feedbackMsg) {
        try {
            JSONObject params = new JSONObject();
            params.put("Language", (Object)Const.CORRECT_LANGUAGE);
            params.put("PlayerId", (Object)String.format("%s|%s", Const.APP_ID, UserProfile.USER_ID));
            params.put("PlayerName", (Object)UserProfile.USER_NAME);
            params.put("FaqId", (Object)botMsg.getFaqMainId());
            params.put("contentId", (Object)botMsg.getFaqContentId());
            params.put("Message", (Object)feedbackMsg);
            params.put("Type", (Object)"1");
            params.put("CreateTime", (Object)String.valueOf(botMsg.getTimeStamp()));
            params.put("PlayerQuestion", (Object)botMsg.getUserInput());
            params.put("TicketId", (Object)botMsg.getFaqTicketId());
            params.put("PitchonQuestion", (Object)botMsg.getBotMsg());
            this.post(API.FAQ_FEEDBACK_URL, params, null);
            StatisticHelper.whenBotFAQGotNegativeFeedback(String.valueOf(botMsg.getTimeStamp()), botMsg.getFaqContentId(), botMsg.getFaqMainId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleBotMsg(ElvaBotMsg botMsg) {
        ConversationDBHelper.storeElvaMsg(botMsg.getTimeStamp(), botMsg.getRawResponse());
        StatisticHelper.whenBotMessagePrepared(botMsg);
        this.prepareNetworkCheck(botMsg);
    }

    private void prepareNetworkCheck(ElvaBotMsg botMsg) {
        if (!Const.TOGGLE_NET_CHECK || TextUtils.isEmpty((CharSequence)Const.NET_CHECK_HOST) || !botMsg.isHasTag()) {
            return;
        }
        if (((BaseCSFragment)this.mView).isNetCheckingInProgress()) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_check_in_progress"));
            return;
        }
        block0: for (BotTag botTag : botMsg.getBotTagList()) {
            for (String pingTags : Const.NET_PING.split(",")) {
                if (!pingTags.equalsIgnoreCase(botTag.getTagName())) continue;
                if (!this.isNetworkAvailable()) {
                    ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
                    return;
                }
                ((BaseCSFragment)this.mView).updateNetCheckingStatus(true);
                Ping.start(Const.NET_CHECK_HOST, new Ping.Callback(){

                    @Override
                    public void complete(Ping.Result result) {
                        ElvaBotPresenter.this.handleNetworkResult(result);
                    }
                });
                break block0;
            }
            for (String pingTags : Const.NET_TRACE_ROUTE.split(",")) {
                if (!pingTags.equalsIgnoreCase(botTag.getTagName())) continue;
                if (!this.isNetworkAvailable()) {
                    ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
                    return;
                }
                ((BaseCSFragment)this.mView).updateNetCheckingStatus(true);
                TraceRoute.start(Const.NET_CHECK_HOST, new TraceRoute.Callback(){

                    @Override
                    public void complete(TraceRoute.Result result) {
                        ElvaBotPresenter.this.handleNetworkResult(result);
                    }
                });
                break block0;
            }
        }
    }

    private void handleNetworkResult(final Object result) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ((BaseCSFragment)ElvaBotPresenter.this.mView).updateNetCheckingStatus(false);
                if (result instanceof Ping.Result) {
                    Ping.Result pingResult = (Ping.Result)result;
                    if (Const.sCheckResultListener != null) {
                        Const.sCheckResultListener.onNetworkCheckResult(pingResult.result);
                    }
                    if (pingResult.sent > 0 && pingResult.avg < 300.0f) {
                        ElvaBotPresenter.this.showNetworkFineToast();
                        return;
                    }
                    ElvaBotPresenter.this.showNetworkSlowDialog(pingResult.result, true);
                }
                if (result instanceof TraceRoute.Result) {
                    TraceRoute.Result traceRouteResult = (TraceRoute.Result)result;
                    if (Const.sCheckResultListener != null) {
                        Const.sCheckResultListener.onNetworkCheckResult(traceRouteResult.content());
                    }
                    ElvaBotPresenter.this.showNetworkSlowDialog(traceRouteResult.content(), false);
                }
            }
        });
    }

    private void showNetworkFineToast() {
        if (this.mContext instanceof Activity) {
            Toast toast = new Toast(this.mContext);
            View view = View.inflate((Context)this.mContext, (int)ResResolver.getLayoutId("aihelp_toast_network_fine"), null);
            TextView textView = (TextView)view.findViewById(ResResolver.getViewId("aihelp_toast_txt"));
            textView.setText((CharSequence)ResResolver.getString("aihelp_network_check_fine"));
            toast.setView(view);
            toast.setGravity(17, 0, 0);
            Activity activity = (Activity)this.mContext;
            if (!activity.isFinishing()) {
                toast.show();
            } else {
                TLog.e("Activity finished when network toast is about to show.");
            }
        }
    }

    private void showNetworkSlowDialog(final String result, final boolean isPing) {
        if (this.mContext instanceof Activity && ((BaseCSFragment)this.mView).isVisible()) {
            final AlertDialog uploadLogDialog = new AlertDialog.Builder(this.mContext).setContentView(ResResolver.getLayoutId("aihelp_dia_upload_net_check")).setWidthByDevice().create();
            TextView tvTitle = (TextView)uploadLogDialog.findViewById(ResResolver.getViewId("aihelp_tv_title"));
            TextView tvSubTitle = (TextView)uploadLogDialog.findViewById(ResResolver.getViewId("aihelp_tv_sub_title"));
            TextView tvCancel = (TextView)uploadLogDialog.findViewById(ResResolver.getViewId("aihelp_tv_cancel"));
            TextView tvConfirm = (TextView)uploadLogDialog.findViewById(ResResolver.getViewId("aihelp_tv_confirm"));
            tvTitle.setText((CharSequence)ResResolver.getString("aihelp_network_upload_log_title"));
            tvSubTitle.setText((CharSequence)ResResolver.getString("aihelp_network_check_poor"));
            tvCancel.setText((CharSequence)ResResolver.getString("aihelp_no"));
            tvConfirm.setText((CharSequence)ResResolver.getString("aihelp_yes"));
            uploadLogDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener(){

                public void onClick(View v) {
                    uploadLogDialog.dismiss();
                }
            });
            uploadLogDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_confirm"), new View.OnClickListener(){

                public void onClick(View v) {
                    EventBus.getDefault().post(new SupportActionEvent(1001, 1007));
                    ElvaBotPresenter.this.postNetworkResultToServer(result, isPing ? "network,ping" : "network,traceroute");
                    ElvaBotPresenter.this.logCheckResultSent(isPing ? "ping" : "traceroute");
                    uploadLogDialog.dismiss();
                }
            });
            Activity activity = (Activity)this.mContext;
            if (!activity.isFinishing()) {
                uploadLogDialog.show();
            } else {
                TLog.e("Activity finished when network dialog is about to show.");
            }
        }
    }

    private void logCheckResultSent(String checkType) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deviceId", (Object)DeviceUuidFactory.id(this.mContext));
            jsonObject.put("playerId", (Object)UserProfile.USER_ID);
            jsonObject.put("type", (Object)checkType);
            this.post(API.LOG_NETWORK_RESULT_SENT, jsonObject, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void postNetworkResultToServer(String userSay, String chatTags) {
        try {
            JSONObject chatParams = new JSONObject();
            chatParams.put("msg", (Object)userSay);
            chatParams.put("timeStamp", System.currentTimeMillis());
            chatParams.put("chatTags", (Object)chatTags);
            chatParams.put("imgFlag", (Object)"0");
            this.mqtt("chat.private", chatParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FaqListEntity> getMatchedFaqListForAlert(String input) {
        return ((ElvaRepository)this.mRepo).getMatchedFaqListForAlert(input);
    }
}

