/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import androidx.fragment.app.Fragment;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.PrepareMessageTimeStampEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.ui.helper.ElvaBotHelper;
import net.aihelp.ui.helper.LoginMqttHelper;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public class MqttCallbackImpl
implements IMqttCallback {
    private BaseFaqFragment faqFragment;
    private BaseCSFragment csFragment;
    private ElvaBotFragment csElvaBot;
    private ConversationFragment csConversation;

    @Override
    public void updateHostView(Fragment fragment) {
        if (fragment instanceof BaseCSFragment) {
            this.csFragment = (BaseCSFragment)fragment;
            if (fragment instanceof ElvaBotFragment) {
                this.csElvaBot = (ElvaBotFragment)fragment;
            } else if (fragment instanceof ConversationFragment) {
                this.csConversation = (ConversationFragment)fragment;
            }
        } else if (fragment instanceof BaseFaqFragment) {
            this.faqFragment = (BaseFaqFragment)fragment;
        }
    }

    @Override
    public void onMqttConnected() {
    }

    @Override
    public void onMqttResponse(int loginType, String topic, String response) {
        try {
            JSONObject responseObject = new JSONObject(response);
            boolean isCodeNot200 = responseObject.has("code") && responseObject.optInt("code") != 200;
            boolean hasErrorCode = responseObject.has("errorCode");
            if (isCodeNot200 || hasErrorCode) {
                return;
            }
            switch (topic) {
                case "login": {
                    this.dismissMqttLoading();
                    List<ConversationMsg> mqttReplyMsg = LoginMqttHelper.getLoginResponse(response);
                    this.csFragment.onMqttLogin(mqttReplyMsg);
                    break;
                }
                case "logout": {
                    AIHelpMqtt.getInstance().logoutMqttConnection();
                    break;
                }
                case "alice.message.chat": {
                    if (this.csElvaBot == null) break;
                    this.csElvaBot.updateChatList(ElvaBotHelper.getMqttReply(response, new boolean[0]));
                    break;
                }
                case "alice.faq.like": {
                    if (this.csElvaBot == null) break;
                    String timeMillis = responseObject.optString("timeMillis");
                    String isLike = responseObject.optString("isLike");
                    String ticketId = responseObject.optString("ticketId");
                    int msgStatus = "1".equals(isLike) ? 200 : 300;
                    this.csElvaBot.updateFAQFeedback(timeMillis, msgStatus, ticketId);
                    break;
                }
                case "chat.private": {
                    ResponseMqttHelper.setTicketActive(true);
                    if (this.csConversation == null) break;
                    boolean postMsgSuccess = "ok".equals(responseObject.optString("state"));
                    this.csConversation.updateMsgStatus(postMsgSuccess, responseObject.optLong("timeStamp"));
                    if (postMsgSuccess) {
                        ResponseMqttHelper.tryUploadLog(responseObject.optBoolean("isUploadLog"));
                    }
                    break;
                }
                case "pushWithdraw": {
                    if (this.csConversation == null) break;
                    this.csConversation.withdrawMsg(ConversationHelper.getWithdrawTimeStamp(response));
                    break;
                }
                case "pushChat": {
                    if (this.csConversation != null && this.csConversation.isVisible()) {
                        ConversationMsg replyMsg = ConversationHelper.getSupportReplyMsg(response);
                        EventBus.getDefault().post(new PrepareMessageTimeStampEvent(replyMsg));
                        this.csConversation.updateChatList(replyMsg);
                        return;
                    }
                    if (this.csElvaBot == null) break;
                    this.csElvaBot.markSupportActionUnread();
                    break;
                }
                case "pushOverflagChat": {
                    ResponseMqttHelper.setTicketWaitForAskingResolveStatus(responseObject.optBoolean("isShowResolve"));
                    ResponseMqttHelper.setTicketWaitForRating(CustomConfig.CustomerService.isTicketRatingEnable);
                    ResponseMqttHelper.setAppRatable("yes".equals(responseObject.optString("storeReview")));
                    if (this.csConversation != null && this.csConversation.isVisible()) {
                        this.csConversation.hideInputAfterConversationFinished();
                        return;
                    }
                    if (this.csElvaBot == null) break;
                    this.csElvaBot.markSupportActionUnread();
                    break;
                }
                case "ticketRejected": {
                    if (this.csConversation == null || !this.csConversation.isVisible()) break;
                    ResponseMqttHelper.setTicketRejected(true);
                    this.csConversation.hideInputAfterConversationFinished();
                    break;
                }
                case "alice.chat.evaluate": {
                    break;
                }
                case "pushFormChat": {
                    ResponseMqttHelper.setFormSubmitStatus(true);
                    ResponseMqttHelper.setTicketActive(true);
                    if (this.csConversation != null) {
                        String formContent = responseObject.optString("msg");
                        this.csConversation.onFormSubmitted(formContent);
                    }
                    if (this.csElvaBot != null) {
                        this.csElvaBot.onFormSubmitted();
                    }
                    LogoutMqttHelper.updateType("8");
                    StatisticHelper.whenFormEventHappened(StatisticHelper.getClickedFormTimeStamp(), 3);
                    ResponseMqttHelper.tryUploadLog(responseObject.getBoolean("isUploadLog"));
                    if (Const.sSpecificFormSubmittedListener == null || !responseObject.getBoolean("isSpecificForm")) break;
                    Const.sSpecificFormSubmittedListener.onFormSubmitted();
                    break;
                }
                case "pushOrderChat": {
                    ResponseMqttHelper.setTicketActive(true);
                    ResponseMqttHelper.setHasUnreadMsg(true);
                    if (this.csElvaBot == null || !this.csElvaBot.isVisible()) break;
                    EventBus.getDefault().post(new SupportActionEvent(1001, 1007));
                    break;
                }
                case "pushSdkMessage": {
                    if (this.faqFragment == null) break;
                    this.faqFragment.showEntranceWithNotification(true);
                }
            }
        }
        catch (Exception e) {
            TLog.e("onMqttResponse, Exception " + e.toString());
            AIHelpLogger.error(response, e);
        }
    }

    @Override
    public void onMqttFailure(String message) {
        this.showMqttLoading();
    }

    @Override
    public void onMqttException() {
    }

    @Override
    public void showMqttLoading() {
        EventBus.getDefault().post(new LoadingElvaEvent(1003));
    }

    @Override
    public void dismissMqttLoading() {
        EventBus.getDefault().post(new LoadingElvaEvent(1004));
    }

    private MqttCallbackImpl() {
    }

    public static IMqttCallback getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final MqttCallbackImpl INSTANCE = new MqttCallbackImpl();

        private LazyHolder() {
        }
    }
}

