/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import net.aihelp.common.Const;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.db.bot.ConversationDBHelper;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.ToastUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class MqttPresenter<V extends IView, R extends IRepository>
extends AbsPresenter<V, R> {
    public MqttPresenter(Context context) {
        super(context);
    }

    @Override
    public boolean isNetworkAvailable() {
        if (this.mContext == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean validateNetwork() {
        boolean isAvailable = this.isNetworkAvailable();
        if (!isAvailable) {
            ToastUtil.makeRawToast(this.mContext, ResResolver.getString("aihelp_network_no_connect"));
        }
        return isAvailable;
    }

    public void logoutMqtt(boolean isConversation) {
        this.logoutMqtt(isConversation, -1);
    }

    public void logoutMqtt(final boolean isConversation, final int resolveType) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject logoutParams = new JSONObject();
                    JSONArray msgArray = ConversationDBHelper.getElvaMsgArray();
                    logoutParams.put("type", isConversation ? 2 : 1);
                    logoutParams.put("feedback", (Object)LogoutMqttHelper.getLogoutType());
                    logoutParams.put("gameinfo", (Object)String.format("{\"platform\":\"android\",\"language\":\"%s\"}", Const.CORRECT_LANGUAGE));
                    logoutParams.put("session_msgs", (Object)msgArray);
                    logoutParams.put("tags", (Object)LogoutMqttHelper.getTagsFromMessageList(msgArray));
                    if (resolveType != -1) {
                        JSONObject resolveObject = new JSONObject();
                        resolveObject.put("resolveType", resolveType);
                        logoutParams.put("resolveEvaluation", (Object)resolveObject);
                    }
                    AIHelpMqtt.getInstance().postToServer("logout", logoutParams);
                    LogoutMqttHelper.resetTypeWhenLogout();
                    ConversationDBHelper.clearElvaMsg();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

