/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.model.cs.storyline;

import android.os.Build;
import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.DeviceInfoUtil;
import org.json.JSONObject;

public class BotUrl {
    private String urlTitle;
    private String urlAddress;

    public BotUrl(String urlTitle, String urlAddress) {
        this.urlTitle = urlTitle;
        this.urlAddress = urlAddress;
        this.getFormattedUrl(urlAddress);
    }

    public String getUrlTitle() {
        return this.urlTitle;
    }

    public void setUrlTitle(String urlTitle) {
        this.urlTitle = urlTitle;
    }

    public String getUrlAddress() {
        return this.urlAddress;
    }

    public void setUrlAddress(String urlAddress) {
        this.urlAddress = urlAddress;
    }

    private void getFormattedUrl(final String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && url.contains("type=login")) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("modelInfo", (Object)String.format("%s %s", Build.MANUFACTURER, Build.MODEL).replace(" ", "-"));
                jsonObject.put("userId", (Object)UserProfile.USER_ID);
                jsonObject.put("serverId", (Object)UserProfile.SERVER_ID);
                jsonObject.put("country", (Object)DeviceInfoUtil.getInstance().getSimCountryIso());
                AIHelpRequest.getInstance().requestPostByJson(API.GET_USER_TOKEN, jsonObject, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        try {
                            String userToken = JsonHelper.optString(new JSONObject(result), "userToken");
                            BotUrl.this.urlAddress = String.format("%s&clientparam=%s", url, userToken);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

