/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.init;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.config.AIHelpContext;
import net.aihelp.config.ConversationConfig;
import net.aihelp.config.FaqConfig;
import net.aihelp.config.OperationConfig;
import net.aihelp.config.UserConfig;
import net.aihelp.config.enums.PublishCountryOrRegion;
import net.aihelp.config.enums.PushPlatform;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.net.monitor.NetworkMonitorManager;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.logic.InitPresenter;
import net.aihelp.exception.AIHelpCrashHandler;
import net.aihelp.exception.AIHelpInitException;
import net.aihelp.ui.listener.OnAIHelpInitializedCallback;
import net.aihelp.ui.listener.OnAIHelpSessionCloseCallback;
import net.aihelp.ui.listener.OnAIHelpSessionOpenCallback;
import net.aihelp.ui.listener.OnMessageCountArrivedCallback;
import net.aihelp.ui.listener.OnNetworkCheckResultCallback;
import net.aihelp.ui.listener.OnOperationUnreadChangedCallback;
import net.aihelp.ui.listener.OnSpecificFormSubmittedCallback;
import net.aihelp.ui.listener.OnSpecificUrlClickedCallback;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SchemaUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

class AIHelpCore {
    private Activity mActivity;
    private Context mAppContext;
    private InitPresenter mInitPresenter;
    private OnAIHelpInitializedCallback initListener;

    public void init(final Context context, String appKey, String domain, String appId, final String language) throws AIHelpInitException {
        try {
            final String trimApiKey = !TextUtils.isEmpty((CharSequence)appKey) ? appKey.trim() : appKey;
            final String trimDomain = !TextUtils.isEmpty((CharSequence)domain) ? domain.trim() : domain;
            final String trimAppId = this.generateAppIdFromAppKey(appKey, domain, appId);
            SchemaUtil.validateInitializeCredentials(context, trimApiKey, trimDomain, trimAppId);
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (context instanceof Activity) {
                        AIHelpCore.this.mActivity = (Activity)context;
                    }
                    AIHelpCore.this.mAppContext = context.getApplicationContext();
                    AIHelpContext.getInstance().setContext(AIHelpCore.this.mAppContext);
                    AIHelpCrashHandler.init();
                    AIHelpCore.this.mInitPresenter = new InitPresenter(AIHelpCore.this.mAppContext, trimApiKey, trimDomain, trimAppId, language);
                    if (SpUtil.getInstance().getBoolean("sp_log_toggle")) {
                        TLog.initLog(true);
                    }
                    NetworkMonitorManager.getInstance().init(AIHelpCore.this.mAppContext);
                    AIHelpCore.this.mInitPresenter.loadUpListeners(AIHelpCore.this.initListener);
                    AIHelpCore.this.mInitPresenter.doInitForAIHelp();
                }
            });
        }
        catch (AIHelpInitException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateAppIdFromAppKey(String appKey, String domain, String appId) {
        if (TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey) && !TextUtils.isEmpty((CharSequence)domain)) {
            String updatedDomain = domain.replace("https://", "").replace("http://", "");
            String newAppKey = HttpConfig.md5(appKey.toLowerCase() + "AIHelpSDKToAndroidAppId");
            String newDomain = updatedDomain.toLowerCase().substring(0, updatedDomain.indexOf("."));
            return newDomain + "_platform_" + newAppKey;
        }
        return appId.trim();
    }

    void updateSDKLanguage(String sdkLanguage) {
        try {
            if (this.isInitStillInProgress()) {
                return;
            }
            this.mInitPresenter.updateSDKLanguage(sdkLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showConversation(ConversationConfig conversationConfig) {
        try {
            if (this.isInitStillInProgress() || MqttConfig.getInstance().isConnected()) {
                return;
            }
            this.mInitPresenter.updateConversationFields(conversationConfig);
            Intent showSupportIntent = IntentValues.getShowSupportIntent(this.mAppContext, conversationConfig);
            if (this.mActivity != null) {
                this.mActivity.startActivity(showSupportIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showSupportIntent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showAllFAQSections(FaqConfig faqConfig) {
        try {
            if (this.isInitStillInProgress()) {
                return;
            }
            this.mInitPresenter.updateConversationFields(faqConfig.getConversationConfig());
            Intent showFAQIntent = IntentValues.getShowFAQIntent(this.mAppContext, faqConfig);
            if (this.mActivity != null) {
                this.mActivity.startActivity(showFAQIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showFAQIntent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showFAQSection(String sectionId, FaqConfig faqConfig) {
        try {
            if (this.isInitStillInProgress()) {
                return;
            }
            this.mInitPresenter.updateConversationFields(faqConfig.getConversationConfig());
            Intent showFAQSectionIntent = IntentValues.getShowFAQSectionIntent(this.mAppContext, sectionId, faqConfig);
            if (this.mActivity != null) {
                this.mActivity.startActivity(showFAQSectionIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showFAQSectionIntent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showSingleFAQ(String mainOrDisplayId, FaqConfig faqConfig) {
        try {
            if (this.isInitStillInProgress()) {
                return;
            }
            this.mInitPresenter.updateConversationFields(faqConfig.getConversationConfig());
            Intent showSingleFAQIntent = IntentValues.getShowSingleFAQIntent(this.mAppContext, mainOrDisplayId, faqConfig);
            if (this.mActivity != null) {
                this.mActivity.startActivity(showSingleFAQIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showSingleFAQIntent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showOperation(OperationConfig operationConfig) {
        try {
            if (this.isInitStillInProgress() || MqttConfig.getInstance().isConnected()) {
                return;
            }
            this.mInitPresenter.updateConversationFields(operationConfig.getConversationConfig());
            Intent showOperateIntent = IntentValues.getShowOperateIntent(this.mAppContext, operationConfig);
            if (this.mActivity != null) {
                this.mActivity.startActivity(showOperateIntent);
            } else {
                this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showOperateIntent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showUrl(String url) {
        try {
            if (this.mAppContext != null && !TextUtils.isEmpty((CharSequence)url)) {
                Intent showUrlIntent = IntentValues.getUrlIntent(this.mAppContext, url);
                if (this.mActivity != null) {
                    this.mActivity.startActivity(showUrlIntent);
                } else {
                    this.mAppContext.startActivity(IntentValues.wrapForApplicationContext(showUrlIntent));
                }
            } else {
                TLog.e("AIHelp", "AIHelpSupport showUrl illegal argument");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateUserInfo(UserConfig config) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.updateUserProfile(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setUploadLogPath(String logPath) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setUploadLogPath(logPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setNetworkCheckHostAddress(String hostAddress, OnNetworkCheckResultCallback listener) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setNetworkCheckHostAddress(hostAddress, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setPushTokenAndPlatform(String pushToken, PushPlatform pushPlatform) {
        try {
            if (this.isPresenterStillNull() || pushPlatform == null) {
                return;
            }
            this.mInitPresenter.postCrmPushTokenInfo(pushToken, pushPlatform.getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void additionalSupportFor(PublishCountryOrRegion countryOrRegion) {
        Const.countryOrRegion = countryOrRegion;
    }

    void startUnreadMessageCountPolling(OnMessageCountArrivedCallback listener) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.startUnreadMessagePolling(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnSpecificFormSubmittedCallback(OnSpecificFormSubmittedCallback callback) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setOnSpecificFormSubmittedCallback(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnAIHelpSessionOpenCallback(OnAIHelpSessionOpenCallback callback) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setOnAIHelpSessionOpenCallback(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnAIHelpSessionCloseCallback(OnAIHelpSessionCloseCallback callback) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setOnAIHelpSessionCloseCallback(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnAIHelpInitializedCallback(OnAIHelpInitializedCallback listener) {
        try {
            if (this.mInitPresenter == null) {
                this.initListener = listener;
                return;
            }
            this.mInitPresenter.loadUpListeners(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnOperationUnreadChangedCallback(OnOperationUnreadChangedCallback callback) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setOnOperationUnreadChangedCallback(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setOnSpecificUrlClickedCallback(OnSpecificUrlClickedCallback callback) {
        try {
            if (this.isPresenterStillNull()) {
                return;
            }
            this.mInitPresenter.setOnSpecificUrlClickedCallback(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableLogging(boolean enable) {
        TLog.initLog(enable);
    }

    private boolean isInitStillInProgress() {
        if (!AIHelpContext.successfullyInit.get()) {
            Log.e((String)"AIHelp", (String)"AIHelp is during initialization process at this time, the API you called is not available, please try again later.");
            return true;
        }
        if (!AppInfoUtil.isNetworkAvailable(this.mAppContext)) {
            ToastUtil.makeRawToast(this.mAppContext, ResResolver.getString("aihelp_network_no_connect"));
            return true;
        }
        return false;
    }

    private boolean isPresenterStillNull() {
        try {
            if (this.mInitPresenter == null) {
                Log.e((String)"AIHelp", (String)"Please ensure AIHelpSupport#init is called at the very first place before you call any other API.");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static AIHelpCore getInstance() {
        return Holder.INSTANCE;
    }

    private AIHelpCore() {
    }

    private static class Holder {
        private static final AIHelpCore INSTANCE = new AIHelpCore();

        private Holder() {
        }
    }
}

