/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter;

import android.content.Context;
import java.util.List;
import net.aihelp.core.ui.adapter.MultiItemTypeAdapter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.storyline.BotOrderInfo;
import net.aihelp.ui.adapter.cs.admin.AdminFaqAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminImageAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminRichTextAdapter;
import net.aihelp.ui.adapter.cs.admin.AdminTextAdapter;
import net.aihelp.ui.adapter.cs.hint.TimeMsgAdapter;
import net.aihelp.ui.adapter.cs.user.UserImageAdapter;
import net.aihelp.ui.adapter.cs.user.UserTextAdapter;
import net.aihelp.ui.adapter.cs.user.UserVideoAdapter;

public class MessageListAdapter
extends MultiItemTypeAdapter<ConversationMsg> {
    private final AdminTextAdapter adminAdapter;
    private final AdminFaqAdapter adminFaqAdapter;
    private final AdminRichTextAdapter adminRichTextAdapter;
    private final UserTextAdapter userAdapter;
    private final UserImageAdapter userImageAdapter;
    private final UserVideoAdapter userVideoAdapter;

    public MessageListAdapter(Context mContext) {
        super(mContext);
        this.adminAdapter = new AdminTextAdapter(mContext);
        this.addItemViewDelegate(this.adminAdapter);
        this.adminRichTextAdapter = new AdminRichTextAdapter(mContext);
        this.addItemViewDelegate(this.adminRichTextAdapter);
        this.adminFaqAdapter = new AdminFaqAdapter(mContext);
        this.addItemViewDelegate(this.adminFaqAdapter);
        this.userAdapter = new UserTextAdapter(mContext);
        this.addItemViewDelegate(this.userAdapter);
        this.addItemViewDelegate(new TimeMsgAdapter(mContext));
        this.userImageAdapter = new UserImageAdapter(mContext);
        this.addItemViewDelegate(this.userImageAdapter);
        this.userVideoAdapter = new UserVideoAdapter(mContext);
        this.addItemViewDelegate(this.userVideoAdapter);
        this.addItemViewDelegate(new AdminImageAdapter(mContext));
    }

    public void insertHistoryConversation(List<ConversationMsg> msgList) {
        this.mDatas.addAll(0, msgList);
        this.notifyDataSetChanged();
    }

    public void setOnClickedListener(OnClickedListenerWrapper mListener) {
        if (this.adminAdapter != null) {
            this.adminAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.adminRichTextAdapter != null) {
            this.adminRichTextAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.adminFaqAdapter != null) {
            this.adminFaqAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userAdapter != null) {
            this.userAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userImageAdapter != null) {
            this.userImageAdapter.setOnClickedListenerWrapper(mListener);
        }
        if (this.userVideoAdapter != null) {
            this.userVideoAdapter.setOnClickedListenerWrapper(mListener);
        }
    }

    public static class OnClickedListenerWrapper
    implements OnTextClickedListener {
        @Override
        public void onActionClicked(String action) {
        }

        @Override
        public void onUrlClicked(String url) {
        }

        @Override
        public void onFormUrlClicked(long timeStamp, String formUrl) {
        }

        @Override
        public void onOrderInfoClicked(BotOrderInfo orderInfo) {
        }

        @Override
        public void onFaqClicked(ElvaBotMsg botMsg) {
        }

        @Override
        public void onFaqHelpfulClicked(boolean helpful, ElvaBotMsg botMsg) {
        }

        @Override
        public void onFaqFeedbackClicked(ElvaBotMsg botMsg) {
        }

        @Override
        public void onRetrySendingMessage(int position, ConversationMsg msg) {
        }
    }

    private static interface OnTextClickedListener {
        public void onActionClicked(String var1);

        public void onUrlClicked(String var1);

        public void onFormUrlClicked(long var1, String var3);

        public void onOrderInfoClicked(BotOrderInfo var1);

        public void onFaqClicked(ElvaBotMsg var1);

        public void onFaqHelpfulClicked(boolean var1, ElvaBotMsg var2);

        public void onFaqFeedbackClicked(ElvaBotMsg var1);

        public void onRetrySendingMessage(int var1, ConversationMsg var2);
    }
}

