/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import java.util.List;
import net.aihelp.data.model.op.OperateSection;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.op.OperateListFragment;

public class OperateViewPagerAdapter
extends FragmentStateAdapter {
    private Bundle bundle;
    private List<OperateSection> sectionList;
    private ElvaBotFragment elvaBotFragment;

    public OperateViewPagerAdapter(@NonNull Fragment fragment, Bundle bundle, List<OperateSection> fragments) {
        super(fragment);
        this.bundle = bundle;
        this.sectionList = fragments;
    }

    public OperateViewPagerAdapter(@NonNull FragmentActivity fragmentActivity, Bundle bundle, List<OperateSection> sectionList) {
        super(fragmentActivity);
        this.bundle = bundle;
        this.sectionList = sectionList;
    }

    @NonNull
    public Fragment createFragment(int position) {
        if (position == this.getItemCount() - 1) {
            boolean humanEmbedded = this.bundle.getBoolean("HUMAN_embedded_in_operation");
            this.elvaBotFragment = ElvaBotFragment.newInstance(this.bundle);
            return humanEmbedded ? ConversationFragment.newInstance(this.bundle) : this.elvaBotFragment;
        }
        this.bundle.putString("operate_section", this.sectionList.get(position).getId());
        return OperateListFragment.getInstance(this.bundle);
    }

    public int getItemCount() {
        return this.sectionList == null ? 0 : this.sectionList.size() + 1;
    }

    public ElvaBotFragment getElvaBotFragment() {
        return this.elvaBotFragment;
    }
}

