/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AdminFaqAdapter
extends BaseMsgAdapter {
    public AdminFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_faq");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == 5;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg s, int position) {
        if (s instanceof ElvaBotMsg) {
            String url;
            int index;
            final ElvaBotMsg botMsg = (ElvaBotMsg)s;
            if (botMsg.isHasUrl() && (index = TextUtils.indexOf((CharSequence)(url = DomainSupportHelper.correctDomain(botMsg.getBotUrl().getUrlAddress())), (CharSequence)"?id=")) != -1) {
                final String faqContentId = url.substring(index + "?id=".length()).replace("&isCustom=1", "");
                botMsg.setFaqContentId(faqContentId);
                ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
                apiExecutor.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        FaqContentEntity faqContentEntity = FaqHelper.INSTANCE.getFaqById(faqContentId);
                        if (faqContentEntity != null) {
                            String faqMainId = faqContentEntity.getFaqMainId();
                            botMsg.setFaqMainId(faqMainId);
                        }
                    }
                });
            }
            LinearLayout llContainer = (LinearLayout)holder.getView(this.getViewId("aihelp_admin_message_container"));
            llContainer.setBackground(this.getAdminBackgroundDrawable(this.isCurrentRtl));
            llContainer.removeAllViews();
            llContainer.addView(this.getFAQLayout(botMsg, this.mWrapper));
            Styles.loadIcon((ImageView)holder.getView(this.getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait, CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_robot");
            holder.setVisible(this.getViewId("aihelp_rl_helpful"), CustomConfig.CommonSetting.isEvaluationForBotEnable && botMsg.getMsgStatus() == 100);
            AppCompatImageButton unhelpfulView = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_faq_unhelpful"));
            Styles.reRenderImageView((ImageView)unhelpfulView, "aihelp_svg_ic_un_helpful");
            unhelpfulView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AdminFaqAdapter.this.mWrapper != null && FastClickValidator.validate()) {
                        AdminFaqAdapter.this.mWrapper.onFaqHelpfulClicked(false, botMsg);
                    }
                }
            });
            AppCompatImageButton helpfulView = (AppCompatImageButton)holder.getView(this.getViewId("aihelp_iv_faq_helpful"));
            Styles.reRenderImageView((ImageView)helpfulView, "aihelp_svg_ic_helpful");
            helpfulView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AdminFaqAdapter.this.mWrapper != null && FastClickValidator.validate()) {
                        AdminFaqAdapter.this.mWrapper.onFaqHelpfulClicked(true, botMsg);
                    }
                }
            });
            LinearLayout llFeedback = (LinearLayout)holder.getView(this.getViewId("aihelp_ll_feedback"));
            llFeedback.setVisibility(CustomConfig.CommonSetting.isEvaluationForBotEnable && botMsg.getMsgStatus() != 100 ? 0 : 8);
            llFeedback.setBackgroundDrawable(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha), 8));
            TextView tvThanks = (TextView)holder.getView(this.getViewId("aihelp_tv_thanks"));
            if (botMsg.getMsgStatus() == 300 || botMsg.getMsgStatus() == 400) {
                Styles.reRenderTextView(tvThanks, CustomConfig.CommonSetting.commonNegativeFeedbackHint, 0.35f);
            } else {
                Styles.reRenderTextView(tvThanks, CustomConfig.CommonSetting.commonPositiveFeedbackHint, 0.35f);
            }
            TextView tvAdvice = (TextView)holder.getView(this.getViewId("aihelp_tv_advice"));
            tvAdvice.setText((CharSequence)ResResolver.getString("aihelp_faq_feedback_suggest"));
            holder.setVisible(this.getViewId("aihelp_tv_advice"), CustomConfig.CommonSetting.isFaqUnhelpfulFeedbackEnable && (botMsg.getMsgStatus() == 300 || botMsg.getMsgStatus() == 400));
            if (botMsg.getMsgStatus() == 300) {
                tvAdvice.setEnabled(true);
                tvAdvice.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor));
            } else if (botMsg.getMsgStatus() == 400) {
                tvAdvice.setEnabled(false);
                tvAdvice.setTextColor(Color.parseColor((String)CustomConfig.CommonSetting.textColor));
                tvAdvice.setAlpha(0.5f);
            }
            tvAdvice.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FastClickValidator.validate() && AdminFaqAdapter.this.mWrapper != null) {
                        AdminFaqAdapter.this.mWrapper.onFaqFeedbackClicked(botMsg);
                    }
                }
            });
        }
    }
}

