/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.chunk;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.NinePatchDrawable;
import java.util.ArrayList;
import net.aihelp.ui.chunk.Div;
import net.aihelp.ui.chunk.DivLengthException;
import net.aihelp.ui.chunk.NinePatchChunk;
import net.aihelp.ui.chunk.WrongPaddingException;

public enum BitmapType {
    NinePatch{

        @Override
        public NinePatchChunk createChunk(Bitmap bitmap) {
            return NinePatchChunk.parse(bitmap.getNinePatchChunk());
        }
    }
    ,
    RawNinePatch{

        @Override
        protected NinePatchChunk createChunk(Bitmap bitmap) {
            try {
                return NinePatchChunk.createChunkFromRawBitmap(bitmap, false);
            }
            catch (WrongPaddingException e) {
                return NinePatchChunk.createEmptyChunk();
            }
            catch (DivLengthException e) {
                return NinePatchChunk.createEmptyChunk();
            }
        }

        @Override
        protected Bitmap modifyBitmap(Resources resources, Bitmap bitmap, NinePatchChunk chunk) {
            Bitmap content = Bitmap.createBitmap((Bitmap)bitmap, (int)1, (int)1, (int)(bitmap.getWidth() - 2), (int)(bitmap.getHeight() - 2));
            int targetDensity = resources.getDisplayMetrics().densityDpi;
            float densityChange = (float)targetDensity / (float)bitmap.getDensity();
            if (densityChange != 1.0f) {
                int dstWidth = Math.round((float)content.getWidth() * densityChange);
                int dstHeight = Math.round((float)content.getHeight() * densityChange);
                content = Bitmap.createScaledBitmap((Bitmap)content, (int)dstWidth, (int)dstHeight, (boolean)true);
                content.setDensity(targetDensity);
                chunk.padding = new Rect(Math.round((float)chunk.padding.left * densityChange), Math.round((float)chunk.padding.top * densityChange), Math.round((float)chunk.padding.right * densityChange), Math.round((float)chunk.padding.bottom * densityChange));
                this.recalculateDivs(densityChange, chunk.xDivs);
                this.recalculateDivs(densityChange, chunk.yDivs);
            }
            bitmap = content;
            return content;
        }

        private void recalculateDivs(float densityChange, ArrayList<Div> divs) {
            for (Div div : divs) {
                div.start = Math.round((float)div.start * densityChange);
                div.stop = Math.round((float)div.stop * densityChange);
            }
        }
    }
    ,
    PlainImage{

        @Override
        protected NinePatchChunk createChunk(Bitmap bitmap) {
            return NinePatchChunk.createEmptyChunk();
        }
    }
    ,
    NULL{

        @Override
        protected NinePatchDrawable createNinePatchDrawable(Resources resources, Bitmap bitmap, String srcName) {
            return null;
        }
    };


    protected NinePatchChunk createChunk(Bitmap bitmap) {
        return NinePatchChunk.createEmptyChunk();
    }

    protected Bitmap modifyBitmap(Resources resources, Bitmap bitmap, NinePatchChunk chunk) {
        return bitmap;
    }

    public static BitmapType determineBitmapType(Bitmap bitmap) {
        if (bitmap == null) {
            return NULL;
        }
        byte[] ninePatchChunk = bitmap.getNinePatchChunk();
        if (ninePatchChunk != null && android.graphics.NinePatch.isNinePatchChunk((byte[])ninePatchChunk)) {
            return NinePatch;
        }
        if (NinePatchChunk.isRawNinePatchBitmap(bitmap)) {
            return RawNinePatch;
        }
        return PlainImage;
    }

    public static NinePatchDrawable getNinePatchDrawable(Resources resources, Bitmap bitmap, String srcName) {
        return BitmapType.determineBitmapType(bitmap).createNinePatchDrawable(resources, bitmap, srcName);
    }

    protected NinePatchDrawable createNinePatchDrawable(Resources resources, Bitmap bitmap, String srcName) {
        NinePatchChunk chunk = this.createChunk(bitmap);
        return new NinePatchDrawable(resources, this.modifyBitmap(resources, bitmap, chunk), chunk.toBytes(), chunk.padding, srcName);
    }
}

