/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.chunk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.NinePatchDrawable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import net.aihelp.ui.chunk.BitmapType;
import net.aihelp.ui.chunk.ChunkNotSerializedException;
import net.aihelp.ui.chunk.Div;
import net.aihelp.ui.chunk.DivLengthException;
import net.aihelp.ui.chunk.ImageLoadingResult;
import net.aihelp.ui.chunk.WrongPaddingException;

public class NinePatchChunk
implements Externalizable {
    public static final int NO_COLOR = 1;
    public static final int TRANSPARENT_COLOR = 0;
    public static final int DEFAULT_DENSITY = 160;
    public boolean wasSerialized = true;
    public ArrayList<Div> xDivs;
    public ArrayList<Div> yDivs;
    public Rect padding = new Rect();
    public int[] colors;

    public static NinePatchChunk parse(byte[] data) throws DivLengthException, ChunkNotSerializedException, BufferUnderflowException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
        NinePatchChunk chunk = new NinePatchChunk();
        boolean bl = chunk.wasSerialized = byteBuffer.get() != 0;
        if (!chunk.wasSerialized) {
            throw new ChunkNotSerializedException();
        }
        byte divXCount = byteBuffer.get();
        NinePatchChunk.checkDivCount(divXCount);
        byte divYCount = byteBuffer.get();
        NinePatchChunk.checkDivCount(divYCount);
        chunk.colors = new int[byteBuffer.get()];
        byteBuffer.getInt();
        byteBuffer.getInt();
        chunk.padding.left = byteBuffer.getInt();
        chunk.padding.right = byteBuffer.getInt();
        chunk.padding.top = byteBuffer.getInt();
        chunk.padding.bottom = byteBuffer.getInt();
        byteBuffer.getInt();
        int xDivs = divXCount >> 1;
        chunk.xDivs = new ArrayList(xDivs);
        NinePatchChunk.readDivs(xDivs, byteBuffer, chunk.xDivs);
        int yDivs = divYCount >> 1;
        chunk.yDivs = new ArrayList(yDivs);
        NinePatchChunk.readDivs(yDivs, byteBuffer, chunk.yDivs);
        for (int i = 0; i < chunk.colors.length; ++i) {
            chunk.colors[i] = byteBuffer.getInt();
        }
        return chunk;
    }

    public static NinePatchDrawable create9PatchDrawable(Context context, Bitmap bitmap, String srcName) {
        return BitmapType.getNinePatchDrawable(context.getResources(), bitmap, srcName);
    }

    public static NinePatchDrawable create9PatchDrawable(Context context, InputStream inputStream, String srcName) {
        return NinePatchChunk.create9PatchDrawable(context, inputStream, 160, srcName);
    }

    public static NinePatchDrawable create9PatchDrawable(Context context, InputStream inputStream, int imageDensity, String srcName) {
        ImageLoadingResult loadingResult = NinePatchChunk.createChunkFromRawBitmap(context, inputStream, imageDensity);
        return loadingResult.getNinePatchDrawable(context.getResources(), srcName);
    }

    public static NinePatchChunk createChunkFromRawBitmap(Bitmap bitmap) {
        try {
            return NinePatchChunk.createChunkFromRawBitmap(bitmap, true);
        }
        catch (RuntimeException e) {
            return NinePatchChunk.createEmptyChunk();
        }
    }

    public static ImageLoadingResult createChunkFromRawBitmap(Context context, InputStream inputStream) {
        return NinePatchChunk.createChunkFromRawBitmap(context, inputStream, 160);
    }

    public static ImageLoadingResult createChunkFromRawBitmap(Context context, InputStream inputStream, int imageDensity) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = imageDensity;
        opts.inTargetDensity = imageDensity;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)new Rect(), (BitmapFactory.Options)opts);
        return NinePatchChunk.createChunkFromRawBitmap(context, bitmap);
    }

    public static ImageLoadingResult createChunkFromRawBitmap(Context context, Bitmap bitmap) {
        BitmapType type = BitmapType.determineBitmapType(bitmap);
        NinePatchChunk chunk = type.createChunk(bitmap);
        bitmap = type.modifyBitmap(context.getResources(), bitmap, chunk);
        return new ImageLoadingResult(bitmap, chunk);
    }

    public static NinePatchChunk createEmptyChunk() {
        NinePatchChunk out = new NinePatchChunk();
        out.colors = new int[0];
        out.padding = new Rect();
        out.yDivs = new ArrayList();
        out.xDivs = new ArrayList();
        return out;
    }

    public byte[] toBytes() {
        int capacity = 32 + this.xDivs.size() * 2 * 4 + this.yDivs.size() * 2 * 4 + this.colors.length * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(capacity).order(ByteOrder.nativeOrder());
        byteBuffer.put(Integer.valueOf(1).byteValue());
        byteBuffer.put(Integer.valueOf(this.xDivs.size() * 2).byteValue());
        byteBuffer.put(Integer.valueOf(this.yDivs.size() * 2).byteValue());
        byteBuffer.put(Integer.valueOf(this.colors.length).byteValue());
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        if (this.padding == null) {
            this.padding = new Rect();
        }
        byteBuffer.putInt(this.padding.left);
        byteBuffer.putInt(this.padding.right);
        byteBuffer.putInt(this.padding.top);
        byteBuffer.putInt(this.padding.bottom);
        byteBuffer.putInt(0);
        for (Div div : this.xDivs) {
            byteBuffer.putInt(div.start);
            byteBuffer.putInt(div.stop);
        }
        for (Div div : this.yDivs) {
            byteBuffer.putInt(div.start);
            byteBuffer.putInt(div.stop);
        }
        for (Object color : (Object)this.colors) {
            byteBuffer.putInt((int)color);
        }
        return byteBuffer.array();
    }

    public static void createColorsArrayAndSet(NinePatchChunk chunk, int bitmapWidth, int bitmapHeight) {
        int[] colorsArray = NinePatchChunk.createColorsArray(chunk, bitmapWidth, bitmapHeight);
        if (chunk != null) {
            chunk.colors = colorsArray;
        }
    }

    public static int[] createColorsArray(NinePatchChunk chunk, int bitmapWidth, int bitmapHeight) {
        if (chunk == null) {
            return new int[0];
        }
        ArrayList<Div> xRegions = NinePatchChunk.getRegions(chunk.xDivs, bitmapWidth);
        ArrayList<Div> yRegions = NinePatchChunk.getRegions(chunk.yDivs, bitmapHeight);
        int[] out = new int[xRegions.size() * yRegions.size()];
        Arrays.fill(out, 1);
        return out;
    }

    public static boolean isRawNinePatchBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        if (bitmap.getWidth() < 3 || bitmap.getHeight() < 3) {
            return false;
        }
        if (!NinePatchChunk.isCornerPixelsAreTrasperent(bitmap)) {
            return false;
        }
        return NinePatchChunk.hasNinePatchBorder(bitmap);
    }

    private static boolean hasNinePatchBorder(Bitmap bitmap) {
        int i;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int lastXPixel = width - 1;
        int lastYPixel = height - 1;
        for (i = 1; i < lastXPixel; ++i) {
            if (NinePatchChunk.isBorderPixel(bitmap.getPixel(i, 0)) && NinePatchChunk.isBorderPixel(bitmap.getPixel(i, lastYPixel))) continue;
            return false;
        }
        for (i = 1; i < lastYPixel; ++i) {
            if (NinePatchChunk.isBorderPixel(bitmap.getPixel(0, i)) && NinePatchChunk.isBorderPixel(bitmap.getPixel(lastXPixel, i))) continue;
            return false;
        }
        if (NinePatchChunk.getXDivs(bitmap, 0).size() == 0) {
            return false;
        }
        if (NinePatchChunk.getXDivs(bitmap, lastYPixel).size() > 1) {
            return false;
        }
        if (NinePatchChunk.getYDivs(bitmap, 0).size() == 0) {
            return false;
        }
        return NinePatchChunk.getYDivs(bitmap, lastXPixel).size() <= 1;
    }

    private static boolean isBorderPixel(int tmpPixel1) {
        return NinePatchChunk.isTransparent(tmpPixel1) || NinePatchChunk.isBlack(tmpPixel1);
    }

    private static boolean isCornerPixelsAreTrasperent(Bitmap bitmap) {
        int lastYPixel = bitmap.getHeight() - 1;
        int lastXPixel = bitmap.getWidth() - 1;
        return NinePatchChunk.isTransparent(bitmap.getPixel(0, 0)) && NinePatchChunk.isTransparent(bitmap.getPixel(0, lastYPixel)) && NinePatchChunk.isTransparent(bitmap.getPixel(lastXPixel, 0)) && NinePatchChunk.isTransparent(bitmap.getPixel(lastXPixel, lastYPixel));
    }

    private static boolean isTransparent(int color) {
        return Color.alpha((int)color) == 0;
    }

    private static boolean isBlack(int pixel) {
        return pixel == -16777216;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.read(bytes);
        try {
            NinePatchChunk patch = NinePatchChunk.parse(bytes);
            this.wasSerialized = patch.wasSerialized;
            this.xDivs = patch.xDivs;
            this.yDivs = patch.yDivs;
            this.padding = patch.padding;
            this.colors = patch.colors;
        }
        catch (DivLengthException divLengthException) {
        }
        catch (ChunkNotSerializedException chunkNotSerializedException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        byte[] bytes = this.toBytes();
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    protected static NinePatchChunk createChunkFromRawBitmap(Bitmap bitmap, boolean checkBitmap) throws WrongPaddingException, DivLengthException {
        if (checkBitmap && !NinePatchChunk.isRawNinePatchBitmap(bitmap)) {
            return NinePatchChunk.createEmptyChunk();
        }
        NinePatchChunk out = new NinePatchChunk();
        NinePatchChunk.setupStretchableRegions(bitmap, out);
        NinePatchChunk.setupPadding(bitmap, out);
        NinePatchChunk.setupColors(bitmap, out);
        return out;
    }

    private static void readDivs(int divs, ByteBuffer byteBuffer, ArrayList<Div> divArrayList) {
        for (int i = 0; i < divs; ++i) {
            Div div = new Div();
            div.start = byteBuffer.getInt();
            div.stop = byteBuffer.getInt();
            divArrayList.add(div);
        }
    }

    private static void checkDivCount(byte divCount) throws DivLengthException {
        if (divCount == 0 || (divCount & 1) != 0) {
            throw new DivLengthException("Div count should be aliquot 2 and more then 0, but was: " + divCount);
        }
    }

    private static void setupColors(Bitmap bitmap, NinePatchChunk out) {
        int bitmapWidth = bitmap.getWidth() - 2;
        int bitmapHeight = bitmap.getHeight() - 2;
        ArrayList<Div> xRegions = NinePatchChunk.getRegions(out.xDivs, bitmapWidth);
        ArrayList<Div> yRegions = NinePatchChunk.getRegions(out.yDivs, bitmapHeight);
        out.colors = new int[xRegions.size() * yRegions.size()];
        int colorIndex = 0;
        for (Div yDiv : yRegions) {
            for (Div xDiv : xRegions) {
                int startX = xDiv.start + 1;
                int startY = yDiv.start + 1;
                if (NinePatchChunk.hasSameColor(bitmap, startX, xDiv.stop + 1, startY, yDiv.stop + 1)) {
                    int pixel = bitmap.getPixel(startX, startY);
                    if (NinePatchChunk.isTransparent(pixel)) {
                        pixel = 0;
                    }
                    out.colors[colorIndex] = pixel;
                } else {
                    out.colors[colorIndex] = 1;
                }
                ++colorIndex;
            }
        }
    }

    private static boolean hasSameColor(Bitmap bitmap, int startX, int stopX, int startY, int stopY) {
        int color = bitmap.getPixel(startX, startY);
        for (int x = startX; x <= stopX; ++x) {
            for (int y = startY; y <= stopY; ++y) {
                if (color == bitmap.getPixel(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    private static void setupPadding(Bitmap bitmap, NinePatchChunk out) throws WrongPaddingException {
        int maxXPixels = bitmap.getWidth() - 2;
        int maxYPixels = bitmap.getHeight() - 2;
        ArrayList<Div> xPaddings = NinePatchChunk.getXDivs(bitmap, bitmap.getHeight() - 1);
        if (xPaddings.size() > 1) {
            throw new WrongPaddingException("Raw padding is wrong. Should be only one horizontal padding region");
        }
        ArrayList<Div> yPaddings = NinePatchChunk.getYDivs(bitmap, bitmap.getWidth() - 1);
        if (yPaddings.size() > 1) {
            throw new WrongPaddingException("Column padding is wrong. Should be only one vertical padding region");
        }
        if (xPaddings.size() == 0) {
            xPaddings.add(out.xDivs.get(0));
        }
        if (yPaddings.size() == 0) {
            yPaddings.add(out.yDivs.get(0));
        }
        out.padding = new Rect();
        out.padding.left = xPaddings.get((int)0).start;
        out.padding.right = maxXPixels - xPaddings.get((int)0).stop;
        out.padding.top = yPaddings.get((int)0).start;
        out.padding.bottom = maxYPixels - yPaddings.get((int)0).stop;
    }

    private static void setupStretchableRegions(Bitmap bitmap, NinePatchChunk out) throws DivLengthException {
        out.xDivs = NinePatchChunk.getXDivs(bitmap, 0);
        if (out.xDivs.size() == 0) {
            throw new DivLengthException("must be at least one horizontal stretchable region");
        }
        out.yDivs = NinePatchChunk.getYDivs(bitmap, 0);
        if (out.yDivs.size() == 0) {
            throw new DivLengthException("must be at least one vertical stretchable region");
        }
    }

    private static ArrayList<Div> getRegions(ArrayList<Div> divs, int max) {
        ArrayList<Div> out = new ArrayList<Div>();
        if (divs == null || divs.size() == 0) {
            return out;
        }
        for (int i = 0; i < divs.size(); ++i) {
            Div div = divs.get(i);
            if (i == 0 && div.start != 0) {
                out.add(new Div(0, div.start - 1));
            }
            if (i > 0) {
                out.add(new Div(divs.get((int)(i - 1)).stop, div.start - 1));
            }
            out.add(new Div(div.start, div.stop - 1));
            if (i != divs.size() - 1 || div.stop >= max) continue;
            out.add(new Div(div.stop, max - 1));
        }
        return out;
    }

    private static ArrayList<Div> getYDivs(Bitmap bitmap, int column) {
        ArrayList<Div> yDivs = new ArrayList<Div>();
        Div tmpDiv = null;
        for (int i = 1; i < bitmap.getHeight(); ++i) {
            tmpDiv = NinePatchChunk.processChunk(bitmap.getPixel(column, i), tmpDiv, i - 1, yDivs);
        }
        return yDivs;
    }

    private static ArrayList<Div> getXDivs(Bitmap bitmap, int raw) {
        ArrayList<Div> xDivs = new ArrayList<Div>();
        Div tmpDiv = null;
        for (int i = 1; i < bitmap.getWidth(); ++i) {
            tmpDiv = NinePatchChunk.processChunk(bitmap.getPixel(i, raw), tmpDiv, i - 1, xDivs);
        }
        return xDivs;
    }

    private static Div processChunk(int pixel, Div tmpDiv, int position, ArrayList<Div> divs) {
        if (NinePatchChunk.isBlack(pixel) && tmpDiv == null) {
            tmpDiv = new Div();
            tmpDiv.start = position;
        }
        if (NinePatchChunk.isTransparent(pixel) && tmpDiv != null) {
            tmpDiv.stop = position;
            divs.add(tmpDiv);
            tmpDiv = null;
        }
        return tmpDiv;
    }
}

