/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.util.ArrayList;
import java.util.List;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.mvp.IPresenter;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.PrepareMessageTimeStampEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.widget.AIHelpChatRecyclerView;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.KeyboardChangeHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

public abstract class BaseCSFragment<P extends IPresenter>
extends BaseFragment<P>
implements View.OnClickListener {
    AIHelpChatRecyclerView rvMsgList;
    MessageListAdapter mAdapter;
    ViewGroup bottomLayout;
    EditText etInput;
    AppCompatImageButton btnSend;
    IMqttCallback mqttCallback;
    boolean isAlwaysShowSupportInElva;
    private KeyboardChangeHelper helper;
    boolean isOperateBot;
    boolean isOperateHuman;
    private ConversationMsg mTimeStampMsg;
    private String titleIcon;
    private String titleText;

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        this.isOperateBot = extras.getBoolean("bot_embedded_in_operation", false);
        this.isOperateHuman = extras.getBoolean("HUMAN_embedded_in_operation", false);
        this.titleIcon = CustomConfig.CustomerService.csNavigationBarTitleIcon;
        this.titleText = CustomConfig.CustomerService.csNavigationTitle;
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new UpdateTitleEvent(1, this.titleIcon, this.titleText));
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(false));
    }

    @Override
    protected void initEventAndData(View contentView) {
        EventBus.getDefault().post(new SupportActionEvent(1002));
        this.mqttCallback = MqttCallbackImpl.getInstance();
        this.bottomLayout = (ViewGroup)this.get("aihelp_chat_bottom_layout");
        this.etInput = (EditText)this.get("aihelp_et_input");
        this.btnSend = (AppCompatImageButton)this.get("aihelp_btn_send");
        this.rvMsgList = (AIHelpChatRecyclerView)((Object)this.get("aihelp_rv_msg_list"));
        this.rvMsgList.setBackgroundColor(0);
        this.mAdapter = new MessageListAdapter(this.getContext());
        this.rvMsgList.setAdapter(this.mAdapter);
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.rvMsgList.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.bottomLayout.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));
        this.etInput.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 8));
        Styles.reRenderTextView((TextView)this.etInput, CustomConfig.CustomerService.csInputHint);
        this.etInput.addTextChangedListener((TextWatcher)new TextWatcherWrapper(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                BaseCSFragment.this.onTextChange(s);
                BaseCSFragment.this.updateSendButtonStatus(s);
            }
        });
        this.helper = new KeyboardChangeHelper(this.getView());
        this.helper.addListener();
        this.helper.addOnKeyboardShowListener(new KeyboardChangeHelper.OnKeyboardShowListener(){

            @Override
            public void onKeyboardShow() {
                int firstVisibleItemPosition;
                if (!linearLayoutManager.getStackFromEnd() && (firstVisibleItemPosition = linearLayoutManager.findFirstCompletelyVisibleItemPosition()) > 0) {
                    linearLayoutManager.setStackFromEnd(true);
                }
                BaseCSFragment.this.scrollRecyclerViewToEnd();
            }

            @Override
            public void onKeyboardHide() {
            }
        });
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        this.btnSend.setClickable(false);
        this.btnSend.setEnabled(false);
    }

    private void updateSendButtonStatus(CharSequence s) {
        try {
            VectorDrawableCompat drawable = VectorDrawableCompat.create((Resources)this.getResources(), (int)ResResolver.getDrawableId("aihelp_svg_ic_send_msg"), null);
            if (drawable != null) {
                int greyColor = Color.parseColor((String)"#C6C9D7");
                int blueColor = Color.parseColor((String)CustomConfig.CommonSetting.interactElementTextColor);
                if (!TextUtils.isEmpty((CharSequence)s.toString().trim())) {
                    this.btnSend.setClickable(true);
                    DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)blueColor);
                } else {
                    this.btnSend.setClickable(false);
                    DrawableCompat.setTint((Drawable)DrawableCompat.wrap((Drawable)drawable).mutate(), (int)greyColor);
                }
                this.btnSend.setImageDrawable((Drawable)drawable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onTextChange(CharSequence s) {
    }

    public void updateChatList(ConversationMsg msg) {
        if (CustomConfig.CustomerService.isMessageTimestampVisible && msg.getMsgType() != 4) {
            this.prepareTimeStamp(msg.getTimeStamp());
        }
        if (msg.getMsgType() == 2 || msg.getMsgType() == 3) {
            this.etInput.setText((CharSequence)"");
            this.updateSendButtonStatus("");
        }
        this.mAdapter.update(msg);
        this.scrollRecyclerViewToEnd();
    }

    private void scrollRecyclerViewToEnd() {
        this.rvMsgList.post(new Runnable(){

            @Override
            public void run() {
                BaseCSFragment.this.rvMsgList.scrollToPosition(BaseCSFragment.this.mAdapter.getItemCount() - 1);
            }
        });
    }

    public void updateChatListClearly(ConversationMsg msg) {
        ArrayList<ConversationMsg> conversationList = new ArrayList<ConversationMsg>();
        conversationList.add(msg);
        this.updateChatList(conversationList);
    }

    public void updateChatList(List<ConversationMsg> msg) {
        this.mAdapter.update(msg, true);
        this.scrollRecyclerViewToEnd();
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.rvMsgList != null) {
            SoftInputUtil.hideSoftInput(this.getContext(), (View)this.rvMsgList);
            this.rvMsgList.setBackgroundColor(0);
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onMqttLogin(List<ConversationMsg> mqttReplyMsg) {
        this.btnSend.setEnabled(true);
        if (this.isVisible()) {
            if (this instanceof ElvaBotFragment && this.getArguments() != null) {
                this.isAlwaysShowSupportInElva = this.getArguments().getBoolean("isContactUsAlwaysOnline");
                if (this.isAlwaysShowSupportInElva) {
                    EventBus.getDefault().post(new SupportActionEvent(1001, 1006));
                }
                if (!TextUtils.isEmpty((CharSequence)Const.CUSTOM_STORY_NODE) || !Const.isLocalWelcomeAvailable) {
                    this.updateChatList(mqttReplyMsg);
                }
            }
            if (this instanceof ConversationFragment) {
                this.updateChatList(mqttReplyMsg);
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.helper != null) {
            this.helper.removeListener();
        }
    }

    public void updateNetCheckingStatus(boolean startChecking) {
    }

    public boolean isNetCheckingInProgress() {
        return false;
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    private void prepareTimeStamp(long timeStamp) {
        if (this.mTimeStampMsg == null || timeStamp - Long.parseLong(this.mTimeStampMsg.getMsgContent()) > 300000L) {
            this.mTimeStampMsg = new ConversationMsg(4, 1003);
            this.mTimeStampMsg.setMsgContent(timeStamp + "");
            this.updateChatList(this.mTimeStampMsg);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(PrepareMessageTimeStampEvent event) {
        if (CustomConfig.CustomerService.isMessageTimestampVisible && this.isVisible()) {
            ConversationMsg newMsg = (ConversationMsg)event.getEvent();
            this.prepareTimeStamp(newMsg.getTimeStamp());
        }
    }
}

