/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.ElvaBotPresenter;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.storyline.BotOrderInfo;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.adapter.faq.FaqAlertAdapter;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.ElvaFaqBottomSheetEvent;
import net.aihelp.ui.helper.ConversationHelper;
import net.aihelp.ui.helper.EvaluateNewHelper;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.SendingBillHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

public class ElvaBotFragment
extends BaseCSFragment<ElvaBotPresenter> {
    private RecyclerView rvFaqHintList;
    private FaqAlertAdapter mFaqAlertAdapter;
    private LinearLayout llChecking;
    private AppCompatImageView ivChecking;
    private int resolveType = -1;

    public static ElvaBotFragment newInstance(Bundle bundle) {
        ElvaBotFragment elvaBot = new ElvaBotFragment();
        elvaBot.setArguments(bundle);
        return elvaBot;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.isOperateBot) {
            if (!MqttConfig.getInstance().isConnected()) {
                ((ElvaBotPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
            }
            return;
        }
        if (ResponseMqttHelper.isFormSubmitted()) {
            EventBus.getDefault().post(new PageHoppingEvent(1008));
        } else {
            ResponseMqttHelper.updateElvaSupportActionStatus(this.isAlwaysShowSupportInElva);
        }
    }

    public void onFormSubmitted() {
        if (this.isVisible()) {
            EventBus.getDefault().post(new PageHoppingEvent(1008));
        }
    }

    @Override
    protected void initEventAndData(View contentView) {
        super.initEventAndData(contentView);
        StatisticHelper.whenBotVisible();
        this.llChecking = (LinearLayout)this.get("aihelp_ll_net_checking");
        this.ivChecking = (AppCompatImageView)this.get("aihelp_iv_checking");
        this.rvFaqHintList = (RecyclerView)this.get("aihelp_rv_faq_alert");
        this.rvFaqHintList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mFaqAlertAdapter = new FaqAlertAdapter(this.getContext(), new View.OnClickListener(){

            public void onClick(View v) {
                ElvaBotFragment.this.mFaqAlertAdapter.clear();
                ElvaBotFragment.this.whenUserSay(((TextView)v).getText().toString());
                StatisticHelper.whenSendButtonClicked();
            }
        });
        this.rvFaqHintList.setAdapter((RecyclerView.Adapter)this.mFaqAlertAdapter);
        this.mAdapter.setOnClickedListener(new MessageListAdapter.OnClickedListenerWrapper(){

            @Override
            public void onActionClicked(String action) {
                ElvaBotFragment.this.whenUserSay(action);
            }

            @Override
            public void onUrlClicked(String url) {
                if (((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).validateNetwork()) {
                    Bundle bundle = new Bundle();
                    bundle.putString("intent_url", url);
                    EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
                }
            }

            @Override
            public void onFormUrlClicked(long timeStamp, String formUrl) {
                if (!MqttConfig.getInstance().isConnected()) {
                    ((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).prepareMqttConnection(ElvaBotFragment.this.mqttCallback);
                }
                if (((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).validateNetwork()) {
                    Bundle bundle = new Bundle();
                    bundle.putString("intent_url", formUrl);
                    EventBus.getDefault().post(new PageHoppingEvent(1009, bundle));
                    LogoutMqttHelper.updateType("7");
                    StatisticHelper.whenFormEventHappened(timeStamp, 2);
                }
            }

            @Override
            public void onOrderInfoClicked(BotOrderInfo orderInfo) {
                if (((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).validateNetwork()) {
                    SendingBillHelper.getInstance().readyToSelectBill(ElvaBotFragment.this.getContext(), orderInfo);
                }
            }

            @Override
            public void onFaqHelpfulClicked(boolean helpful, ElvaBotMsg botMsg) {
                if (((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).validateNetwork()) {
                    ((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).markWhetherFaqHelpful(helpful, botMsg);
                    LogoutMqttHelper.updateType(helpful ? "1" : "2");
                }
            }

            @Override
            public void onFaqFeedbackClicked(ElvaBotMsg botMsg) {
                ElvaBotFragment.this.showAdviceAlert(botMsg);
            }

            @Override
            public void onFaqClicked(final ElvaBotMsg botMsg) {
                if (((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).validateNetwork() && botMsg != null && botMsg.getBotUrl() != null) {
                    String url = DomainSupportHelper.correctDomain(botMsg.getBotUrl().getUrlAddress());
                    int index = TextUtils.indexOf((CharSequence)url, (CharSequence)"?id=");
                    if (index != -1) {
                        final String faqContentId = url.substring(index + "?id=".length()).replace("&isCustom=1", "");
                        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
                        apiExecutor.runAsync(new Runnable(){

                            @Override
                            public void run() {
                                FaqContentEntity faqContentEntity = FaqHelper.INSTANCE.getFaqById(faqContentId);
                                if (faqContentEntity != null) {
                                    String faqMainId = faqContentEntity.getFaqMainId();
                                    botMsg.setFaqMainId(faqMainId);
                                    botMsg.setFaqContentId(faqContentId);
                                }
                            }
                        });
                    }
                    ElvaFaqBottomSheetEvent dialog = new ElvaFaqBottomSheetEvent(ElvaBotFragment.this, botMsg);
                    dialog.setOnBotFaqInteractionCallback(new ElvaFaqBottomSheetEvent.OnBotFaqInteractionCallback(){

                        @Override
                        public void onEvaluatedFaq(boolean isHelpful) {
                            ((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).markWhetherFaqHelpful(isHelpful, botMsg);
                        }

                        @Override
                        public void onDialogDismissed() {
                            ElvaBotFragment.this.mAdapter.notifyDataSetChanged();
                        }
                    });
                    dialog.show(url);
                }
            }
        });
        if (!this.isOperateBot) {
            ((ElvaBotPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
        }
    }

    private void showAdviceAlert(final ElvaBotMsg botMsg) {
        final AlertDialog feedbackDialog = new AlertDialog.Builder(this.getContext()).setContentView(ResResolver.getLayoutId("aihelp_dia_advice")).setCancelableOntheOutside(true).setWidthByDevice().create();
        final EditText etFeedback = (EditText)feedbackDialog.getView(ResResolver.getViewId("aihelp_et_feedback"));
        TextView tvTitle = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
        TextView tvCancel = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_cancel"));
        final TextView tvConfirm = (TextView)feedbackDialog.getView(ResResolver.getViewId("aihelp_tv_confirm"));
        etFeedback.setHint((CharSequence)ResResolver.getString("aihelp_chat_hint"));
        tvTitle.setText((CharSequence)ResResolver.getString("aihelp_faq_feedback"));
        tvCancel.setText((CharSequence)ResResolver.getString("aihelp_no"));
        tvConfirm.setText((CharSequence)ResResolver.getString("aihelp_yes"));
        etFeedback.addTextChangedListener((TextWatcher)new TextWatcherWrapper(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvConfirm.setEnabled(!TextUtils.isEmpty((CharSequence)s.toString().trim()));
                tvConfirm.setAlpha(TextUtils.isEmpty((CharSequence)s.toString().trim()) ? 0.5f : 1.0f);
            }
        });
        feedbackDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener(){

            public void onClick(View v) {
                feedbackDialog.dismiss();
            }
        });
        feedbackDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_confirm"), new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.isEmpty((CharSequence)etFeedback.getText().toString().trim())) {
                    ToastUtil.makeRawToast(ElvaBotFragment.this.getContext(), ResResolver.getString("aihelp_faq_feedback"));
                    return;
                }
                ((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).postFeedbackOnFaq(botMsg, etFeedback.getText().toString().trim());
                feedbackDialog.dismiss();
                SoftInputUtil.hideSoftInput(ElvaBotFragment.this.getContext(), (View)etFeedback);
                ElvaBotFragment.this.updateFAQFeedback(String.valueOf(botMsg.getTimeStamp()), 400, botMsg.getFaqTicketId());
            }
        });
        feedbackDialog.show();
    }

    @Override
    protected void onTextChange(final CharSequence s) {
        if (TextUtils.isEmpty((CharSequence)s.toString().trim())) {
            this.rvFaqHintList.setVisibility(8);
            this.mFaqAlertAdapter.clear();
            return;
        }
        final ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runAsync(new Runnable(){

            @Override
            public void run() {
                final List<FaqListEntity> faqs = ((ElvaBotPresenter)ElvaBotFragment.this.mPresenter).getMatchedFaqListForAlert(String.valueOf(s));
                apiExecutor.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ElvaBotFragment.this.rvFaqHintList.setVisibility(faqs.size() > 0 ? 0 : 8);
                        ElvaBotFragment.this.mFaqAlertAdapter.update(faqs, true);
                    }
                });
            }
        });
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_elva_bot");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_elva_root");
    }

    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            StatisticHelper.whenSendButtonClicked();
            String input = this.etInput.getText().toString();
            this.whenUserSay(input);
        }
    }

    private void whenUserSay(String userSay) {
        this.updateChatList(ConversationHelper.getUserTextMsg(true, userSay));
        Message message = Message.obtain();
        message.obj = userSay;
        this.mHandler.sendMessage(message);
    }

    @Override
    protected void handleMsg(Message msg) {
        String userInput = (String)msg.obj;
        final ElvaBotMsg botReply = ConversationHelper.getBotReply(userInput);
        if (!botReply.isBotStupid() || !((ElvaBotPresenter)this.mPresenter).isNetworkAvailable()) {
            this.rvMsgList.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ElvaBotFragment.this.updateChatList(botReply);
                }
            }, 800L);
        } else {
            ((ElvaBotPresenter)this.mPresenter).askForAnswer(userInput);
        }
    }

    @Override
    public void updateChatList(ConversationMsg msg) {
        super.updateChatList(msg);
        if (msg instanceof ElvaBotMsg) {
            ElvaBotMsg botMsg = (ElvaBotMsg)msg;
            ((ElvaBotPresenter)this.mPresenter).handleBotMsg(botMsg);
        }
    }

    public void updateFAQFeedback(String timeMillis, boolean isLike, String ticketId) {
        for (int i = 0; i < this.mAdapter.getDataList().size(); ++i) {
            ConversationMsg conversationMsg = (ConversationMsg)this.mAdapter.getDataList().get(i);
            if (conversationMsg.getMsgType() != 5 || !String.valueOf(conversationMsg.getTimeStamp()).equals(timeMillis)) continue;
            conversationMsg.setMsgStatus(isLike ? 200 : 300);
            conversationMsg.setFaqTicketId(ticketId);
            this.mAdapter.notifyItemChanged(i);
        }
    }

    public void updateFAQFeedback(String timeMillis, int msgStatus, String ticketId) {
        for (int i = 0; i < this.mAdapter.getDataList().size(); ++i) {
            ConversationMsg conversationMsg = (ConversationMsg)this.mAdapter.getDataList().get(i);
            if (conversationMsg.getMsgType() != 5 || !String.valueOf(conversationMsg.getTimeStamp()).equals(timeMillis)) continue;
            conversationMsg.setMsgStatus(msgStatus);
            conversationMsg.setFaqTicketId(ticketId);
            this.mAdapter.notifyItemChanged(i);
        }
    }

    @Override
    public void onMqttLogin(List<ConversationMsg> mqttReplyMsg) {
        super.onMqttLogin(mqttReplyMsg);
        if (this.isVisible() && (ResponseMqttHelper.isTicketActive() || ResponseMqttHelper.isTicketRejected())) {
            EventBus.getDefault().post(new PageHoppingEvent(1008));
        }
    }

    public void markSupportActionUnread() {
        ResponseMqttHelper.setHasUnreadMsg(true);
        if (this.isVisible()) {
            EventBus.getDefault().post(new SupportActionEvent(1001, 1007));
        }
    }

    @Override
    public void updateNetCheckingStatus(boolean startChecking) {
        if (this.llChecking != null && this.ivChecking != null) {
            if (startChecking) {
                TextView tvNetChecking = (TextView)this.get("aihelp_tv_net_checking");
                tvNetChecking.setText((CharSequence)ResResolver.getString("aihelp_network_checking"));
                this.llChecking.setVisibility(0);
                ObjectAnimator loadingAnimator = ObjectAnimator.ofFloat((Object)this.ivChecking, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
                loadingAnimator.setDuration(1000L);
                loadingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                loadingAnimator.setRepeatCount(-1);
                loadingAnimator.start();
            } else {
                this.llChecking.setVisibility(8);
            }
        }
    }

    @Override
    public boolean isNetCheckingInProgress() {
        return this.llChecking != null && this.llChecking.getVisibility() == 0;
    }

    public boolean onBackPressed() {
        if (this.isNetCheckingInProgress()) {
            this.showNetworkInterruptDialog();
            return false;
        }
        if (CustomConfig.CustomerService.isBotResolveQueryEnable && !ResponseMqttHelper.isTicketActive() && this.mAdapter != null && this.mAdapter.getItemCount() > 1) {
            EvaluateNewHelper.getInstance().askAboutIssueResolvedStatus(this.getContext(), null, new EvaluateNewHelper.OnConfirmResolveStatusListener(){

                @Override
                public void onConfirmResolve(boolean isResolved) {
                    ElvaBotFragment.this.resolveType = isResolved ? 1 : 2;
                    CustomConfig.CustomerService.isBotResolveQueryEnable = false;
                    if (ElvaBotFragment.this.getActivity() != null) {
                        ElvaBotFragment.this.getActivity().onBackPressed();
                    }
                }
            });
            return false;
        }
        return true;
    }

    private void showNetworkInterruptDialog() {
        if (this.getActivity() != null) {
            final AlertDialog netCheckDialog = new AlertDialog.Builder(this.getContext()).setContentView(ResResolver.getLayoutId("aihelp_dia_interrupt_net_check")).setWidthByDevice().create();
            TextView tvTitle = (TextView)netCheckDialog.getView(ResResolver.getViewId("aihelp_tv_title"));
            TextView tvCancel = (TextView)netCheckDialog.getView(ResResolver.getViewId("aihelp_tv_cancel"));
            TextView tvConfirm = (TextView)netCheckDialog.getView(ResResolver.getViewId("aihelp_tv_confirm"));
            tvTitle.setText((CharSequence)ResResolver.getString("aihelp_network_check_in_progress"));
            tvCancel.setText((CharSequence)ResResolver.getString("aihelp_no"));
            tvConfirm.setText((CharSequence)ResResolver.getString("aihelp_yes"));
            netCheckDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_cancel"), new View.OnClickListener(){

                public void onClick(View v) {
                    netCheckDialog.dismiss();
                }
            });
            netCheckDialog.setOnClickListener(ResResolver.getViewId("aihelp_tv_confirm"), new View.OnClickListener(){

                public void onClick(View v) {
                    netCheckDialog.dismiss();
                    if (ElvaBotFragment.this.llChecking != null) {
                        ElvaBotFragment.this.llChecking.setVisibility(8);
                    }
                    if (ElvaBotFragment.this.getActivity() != null) {
                        ElvaBotFragment.this.getActivity().onBackPressed();
                    }
                }
            });
            if (this.getActivity() != null && !this.getActivity().isFinishing()) {
                netCheckDialog.show();
            } else {
                TLog.e("Activity finished when network dialog is about to show.");
            }
        }
    }

    @Override
    public void onNetworkStateChanged(NetworkState networkState) {
        if (networkState == NetworkState.NONE) {
            this.mqttCallback.onMqttFailure(null);
        } else {
            ((ElvaBotPresenter)this.mPresenter).prepareMqttConnection(this.mqttCallback);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mPresenter != null) {
            ((ElvaBotPresenter)this.mPresenter).logoutMqtt(false, this.resolveType);
        }
        super.onDestroy();
    }
}

