/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import org.json.JSONObject;

public class ElvaFaqBottomSheetEvent
implements View.OnClickListener {
    private AlertDialog faqAlertDialog;
    private RelativeLayout rootLayout;
    private AIHelpWebView mWebView;
    private OnBotFaqInteractionCallback mListener;

    @SuppressLint(value={"ClickableViewAccessibility"})
    public ElvaFaqBottomSheetEvent(Fragment fragment, @NonNull ElvaBotMsg botMsg) {
        if (fragment == null || fragment.getContext() == null) {
            return;
        }
        Context context = fragment.getContext();
        this.faqAlertDialog = new AlertDialog.Builder(fragment.getContext()).setContentView(ResResolver.getLayoutId("aihelp_dia_elva_faq")).setGravity(80).fromBottom(true).setCancelableOntheOutside(true).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                EventBus.getDefault().unregister(ElvaFaqBottomSheetEvent.this);
                if (ElvaFaqBottomSheetEvent.this.mListener != null) {
                    ElvaFaqBottomSheetEvent.this.mListener.onDialogDismissed();
                }
            }
        }).setWidthAndHeight(-1, 500).setHeightByDevice().create();
        this.rootLayout = (RelativeLayout)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_rl_root"));
        this.rootLayout.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));
        final ImageView ivBack = (ImageView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        ivBack.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back");
        ImageView ivClose = (ImageView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        ivClose.setOnClickListener((View.OnClickListener)this);
        Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");
        this.mWebView = (AIHelpWebView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_web_view"));
        AIHelpWebProgress progressBar = (AIHelpWebProgress)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_progress_bar"));
        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(fragment.getContext(), progressBar);
        webViewClient.setUrlLoadingListener(new AIHelpWebViewClient.ShouldOverrideUrlLoadingListener(){

            @Override
            public void handleUrlClick(boolean result) {
                if (result) {
                    ivBack.setVisibility(0);
                }
            }
        });
        this.mWebView.setWebViewClient(webViewClient);
        AIHelpWebChromeClient chromeClient = new AIHelpWebChromeClient(fragment, progressBar);
        this.mWebView.setWebChromeClient(chromeClient);
        this.mWebView.setBackgroundColor(0);
        this.prepareEvaluateView(botMsg);
        EventBus.getDefault().register(this);
    }

    private void prepareEvaluateView(final ElvaBotMsg botMsg) {
        AIHelpEvaluateView evaluateView = (AIHelpEvaluateView)this.faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_evaluate_bot_faq"));
        evaluateView.setMainId(botMsg.getFaqMainId());
        evaluateView.setContentId(botMsg.getFaqContentId());
        if (CustomConfig.CommonSetting.isEvaluationForBotEnable) {
            switch (botMsg.getMsgStatus()) {
                case 300: {
                    evaluateView.setEvaluateState(4);
                    break;
                }
                case 200: 
                case 400: {
                    evaluateView.setEvaluateState(2);
                    break;
                }
                default: {
                    evaluateView.setEvaluateState(1);
                    break;
                }
            }
        } else {
            evaluateView.setEvaluateState(2);
        }
        evaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback(){

            @Override
            public void onEvaluated(boolean isHelpful) {
                botMsg.setMsgStatus(isHelpful ? 200 : 300);
                if (ElvaFaqBottomSheetEvent.this.mListener != null) {
                    ElvaFaqBottomSheetEvent.this.mListener.onEvaluatedFaq(isHelpful);
                }
            }

            @Override
            public void onFeedbackConfirmed() {
                botMsg.setMsgStatus(400);
            }

            @Override
            public JSONObject requestDataForFeedback() {
                try {
                    JSONObject params = new JSONObject();
                    params.put("PlayerQuestion", (Object)botMsg.getUserInput());
                    params.put("TicketId", (Object)botMsg.getFaqTicketId());
                    params.put("PitchonQuestion", (Object)botMsg.getBotMsg());
                    params.put("CreateTime", botMsg.getTimeStamp());
                    return params;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.requestDataForFeedback();
                }
            }
        });
    }

    private void onBackPressed(View view) {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            if (!this.mWebView.canGoBack()) {
                view.setVisibility(8);
            }
        }
    }

    public void show(FaqContentEntity faq) {
        if (this.faqAlertDialog != null) {
            this.faqAlertDialog.show();
        }
        this.mWebView.loadDataWithBaseURL(null, faq.getFaqContent(), "text/html", "utf-8", null);
    }

    public void show(String url) {
        this.mWebView.loadUrl(url);
        if (this.faqAlertDialog != null) {
            this.faqAlertDialog.show();
        }
    }

    public void setOnBotFaqInteractionCallback(OnBotFaqInteractionCallback listener) {
        this.mListener = listener;
    }

    public void onClick(View v) {
        if (this.faqAlertDialog == null) {
            return;
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_close")) {
            this.faqAlertDialog.dismiss();
        }
        if (v.getId() == ResResolver.getViewId("aihelp_iv_back")) {
            this.onBackPressed(v);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (this.faqAlertDialog != null && this.faqAlertDialog.isShowing()) {
            this.faqAlertDialog.dismiss();
        }
    }

    public static abstract class OnBotFaqInteractionCallback {
        public void onEvaluatedFaq(boolean isHelpful) {
        }

        public void onDialogDismissed() {
        }
    }
}

