/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;
import net.aihelp.common.CustomConfig;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqContentFragment
extends BaseFaqFragment<FaqPresenter> {
    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;
    private AIHelpEvaluateView mEvaluateView;
    private AIHelpServiceEntrance mServiceEntrance;

    public static FaqContentFragment newInstance(Bundle bundle) {
        FaqContentFragment faqFragment = new FaqContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        FrameLayout flContent = (FrameLayout)this.get("aihelp_ll_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);
        this.mProgressBar = (AIHelpWebProgress)((Object)this.get("aihelp_progress_bar"));
        this.mEvaluateView = (AIHelpEvaluateView)((Object)this.get("aihelp_evaluate_faq"));
        this.mServiceEntrance = (AIHelpServiceEntrance)((Object)this.get("aihelp_cs_entrance"));
        this.mWebView = (AIHelpWebView)((Object)this.get("aihelp_web_view"));
        this.mWebView.setBackgroundColor(0);
        this.mWebView.setWebViewClient(new AIHelpWebViewClient(this.getContext(), this.mProgressBar));
        this.mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, this.mProgressBar));
    }

    @Override
    public void onResume() {
        int supportMoment;
        super.onResume();
        if (this.getArguments() != null && !ResponseMqttHelper.isHasUnreadMsg() && (supportMoment = this.getArguments().getInt("faq_support_moment", 1001)) == 1003) {
            this.mServiceEntrance.setVisibility(0);
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String sectionId = extras.getString("section_id");
        String faqId = extras.getString("faq_main_id");
        String searchTerm = extras.getString("search_match");
        ((FaqPresenter)this.mPresenter).goFetchQuestionContent(sectionId, faqId, searchTerm);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_faq_content");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_faq_content");
    }

    @Override
    public void refreshQuestionContent(final FaqContentEntity faq) {
        if (faq != null) {
            this.mEvaluateView.setMainId(faq.getFaqMainId());
            this.mEvaluateView.setContentId(faq.getFaqContentId());
            if (CustomConfig.CommonSetting.isEvaluationForAnswerPageEnable && ((FaqPresenter)this.mPresenter).shouldShowQuestionFooter(faq.getFaqMainId())) {
                this.mEvaluateView.setEvaluateState(1);
            } else {
                this.mEvaluateView.setEvaluateState(2);
            }
            this.mEvaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback(){

                @Override
                public void onEvaluated(boolean isHelpful) {
                    int supportMoment;
                    if (!isHelpful && FaqContentFragment.this.getArguments() != null && (supportMoment = FaqContentFragment.this.getArguments().getInt("faq_support_moment", 1001)) == 1004) {
                        FaqContentFragment.this.mServiceEntrance.setVisibility(0);
                    }
                    FaqHelper.INSTANCE.afterFaqEvaluated(faq.getFaqMainId());
                }
            });
            String faqContent = DomainSupportHelper.correctDomain(faq.getFaqContent());
            int[] colorRGB = Styles.getColorRGB(CustomConfig.CommonSetting.textColor);
            String textColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 1);
            String timeColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 0.3);
            faqContent = faqContent.replace("<body>", String.format("<body style=\"background-color: transparent; %s\">", textColor));
            faqContent = faqContent.replace("<div style='font-size:14px;color:#CCCCCC;'>", String.format("<div style='font-size:14px; %s'>", timeColor));
            this.mWebView.loadDataWithBaseURL(null, faqContent, "text/html", "utf-8", null);
            StatisticHelper.whenFAQDetailVisible(faq.getFaqMainId(), faq.getFaqContentId());
        } else {
            this.showEmpty(new int[0]);
        }
    }

    public void onStop() {
        super.onStop();
        this.mProgressBar.hide();
    }

    public boolean onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
            return false;
        }
        return true;
    }
}

